package com.qiho.manager.common.enums;

import java.util.Objects;

/**
 * @author Wangpf
 * @description 名单管控枚举类 主要是用来展示不同短信模板代码对应的产品文案
 * @date 2020/2/26 10:25 AM
 */
public enum MessageManagementEnum {

    /**
     * 全部场景
     */
    ALL("ALL","全部场景"),

    /**
     * 下单场景
     */
    ORDER_SUCCESS("ORDER_SUCCESS","下单通知")
    ;

    /**
     * 代码
     */
    private final String code;

    /**
     * 描述
     */
    private final String desc;

    MessageManagementEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据模板代码获取文案
     *
     * @param code
     * @return
     */
    public static String getDescByCode(String code) {
        for (MessageManagementEnum messageManagementEnum : MessageManagementEnum.values()) {
            if (Objects.equals(code, messageManagementEnum.getCode())) {
                return messageManagementEnum.getDesc();
            }
        }
        return null;
    }

}
