package com.qiho.manager.common.enums;

/**
 * @author Wangpf
 * @description  redisKEy 枚举
 * @date 2020/4/10 10:18 AM
 */
public enum RedisKeyEnum {

    SENSITIVIE_WORD_KEY("sensitive-word-key","短信模版敏感词Key")
    ;

    /**
     * Redis->key
     */
    private final String key;

    /**
     * Key 描述
     */
    private final String desc;

    private static final String SYSTEM_NAME = "qiho-manager";

    RedisKeyEnum(String key,String desc) {
        this.key = key;
        this.desc = desc;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }

    public  String getFinalKey(){
        return String.join("-",SYSTEM_NAME, getKey());
    }

}
