package com.qiho.manager.common.util;

import java.text.SimpleDateFormat;

import cn.com.duiba.wolf.utils.UUIDUtils;

/**
 * 生成AppSecret工具类
 *
 * @Author jiafeng.geng
 * @Date 2018-03-09 16:12:29
 */
public class AppSecretUtil {

    private AppSecretUtil() {
    }

    /**
     * 根据指定规则生成AppSecret, 生成规则为：随机码(UUID生成并截取前16位) + 时间戳(14位)
     *
     * @param
     *
     * @return string
     */
    public static String getAppSecret() {
        StringBuilder appSecret = new StringBuilder();
        String uuidStr = UUIDUtils.createUUID().substring(0, 16);
        String currentTime = new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis());
        appSecret.append(uuidStr).append(currentTime);
        return appSecret.toString();
    }
}
