package com.qiho.manager.common.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.qiho.manager.common.exception.QihoManagerException;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;

/**
 * Created by liuyao on 2017/6/7.
 */
@Service("ossFileService")
public class OSSFileService {
    private static final Logger log = LoggerFactory.getLogger(OSSFileService.class);
    @Autowired
    private OSSClient ossClient;

    @Value("${oss.bucketName}")
    private String bucketName;

    /**
     * 获取的
     * @param url
     * @return
     */
    public String getOssFileContent(String url){
        InputStream content = getOssFileInputStream(url);
        try{
            if(content==null){
                return "";
            }
            return IOUtils.toString(content, Charset.forName("UTF-8"));
        }catch(IOException e) {
            throw new QihoManagerException("获取Oss文件失败",e);
        }finally {
            closeInputStream(content);
        }
    }

    /**
     * 获取文件输入流
     * @param url
     * @return
     */
    public InputStream getOssFileInputStream(String url){
        String key = getOssKey(url);
        OSSObject ossObject = ossClient.getObject(bucketName, key);
        return ossObject.getObjectContent();
    }

    /**
     * 关闭流
     * @param input
     */
    public void closeInputStream(InputStream input){
        IOUtils.closeQuietly(input);
    }

    private String getOssKey(String url){
        String urlWithProtocol = url;
        if(StringUtils.startsWith(url, "//")){
            urlWithProtocol = "http:" + url;
        }
        try {
            
            URL urlFix = new URL(urlWithProtocol);
            String key = urlFix.getPath();
            if(key.startsWith("/")){
                key = key.substring(1,key.length());
            }
            return key;
        }catch(MalformedURLException e){
            log.error("oss地址解析出错url={}",e,url);
            throw new QihoManagerException("oss地址解析出错",e);
        }
    }

}
