package com.qiho.manager.common.util;

/**
 * Created by danke on 2017/6/19.
 */

import cn.com.duiba.wolf.utils.NumberUtils;
import com.google.common.collect.Lists;
import com.qiho.manager.common.exception.QihoManagerException;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {

    private static final String SPLITTER = ",";

    private StringUtil(){
    }

    public static String subStr(String value, int maxSize) {
        if (null == value || "".equals(value) || value.length() <= maxSize) {
            return value;
        }
        return value.substring(0, maxSize) + "...";
    }

    public static boolean isNotEmpty(String value) {
        return !isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public static boolean isNumeric(String value) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(value).matches();
    }

    /** 负数或小数的判断 */
    public static boolean isNum(String value){
        Pattern pattern = Pattern.compile("-?[0-9]+.*[0-9]*");
        return pattern.matcher(value).matches();
    }

    /**
     * id转url
     *
     * @param id
     * @return
     */
    public static String idtourl(Long id) {
        if (id == null) {
            return "";
        }
        return 1 + Long.toString(id * 2 + 56, 36);
    }

    public static long urltolongId(String url) {
        return (Long.parseLong(url.substring(1), 36) - 56) / 2;
    }
    public static int urltoid(String url) {
        return (Integer.parseInt(url.substring(1), 36) - 56) / 2;
    }

    /**
     * 去掉cdn前缀
     *
     * @param imagePath
     * @return
     */
    public static String removeCdnPath(String imagePath) {
        if (null == imagePath || "" == imagePath) {
            return imagePath;
        }
        if (imagePath.contains("mogucdn")) {
            return imagePath.substring(imagePath.indexOf(".com") + 4);
        } else {
            return imagePath;
        }
    }

    /**
     * 去除空格、回车、换行符、制表符等
     *
     * @param str
     * @return
     */
    public static String replaceBlank(String str) {
        return replaceBlank(str, "\\s*|\t|\r|\n");
    }

    /**
     * 根据指定正则去除
     * @param str
     * @param regex
     * @return
     */
    public static String replaceBlank(String str, String regex) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    /**
     * 根据指定正则去除，不包括中间空格
     * @param str
     * @param regex
     * @return
     */
    public static String replaceBlankWithoutMid(String str, String regex) {
        String dest = "";
        if (str != null) {
            Pattern pattern = Pattern.compile("(^[" + regex + "])|([" + regex + "]+$)");// 首尾特殊字符
            dest = pattern.matcher(str).replaceAll("");
        }
        return dest;
    }

    public static Map<String, String> strToMap(String str) {
        if (str.isEmpty()) {
            return null;
        }
        Map<String, String> map = new HashMap<>();
        String[] strs = str.split(";");
        for (String s : strs) {
            String[] sTmp = s.split(":");
            map.put(sTmp[0], sTmp[1]);
        }
        return map;
    }

    public static String mapToStr(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }

        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key == null || key.isEmpty()) {
                continue;
            }
            if (value == null || value.isEmpty()) {
                value = "";
            }
            sb.append(key).append(":").append(value).append(";");
        }
        return sb.toString();
    }

    /**
     * 字符串拼接
     *
     * @param separator
     * @param str1
     * @param str2
     * @return
     */
    public static String appendStr(String separator, String str1, String str2) {
        if (StringUtil.isEmpty(str2)) {
            return str1;
        }

        StringBuilder sb = new StringBuilder();
        if (StringUtil.isEmpty(str1)) {
            sb.append(str2);
        } else {
            sb.append(str1).append(separator).append(str2);
        }
        return sb.toString();

    }

    // explode
    public static List<Integer> explode(String delimiter, String string) {
        List<Integer> ret = Lists.newArrayList();
        if (isEmpty(string)) {
            return ret;
        } else {
            String[] stringArray = string.split(delimiter);
            if (stringArray.length > 0) {
                for (String id : stringArray) {
                    ret.add(Integer.parseInt(id));
                }
            }
        }
        return ret;
    }

    /**
     * 字符串转Integer并去除头部0
     * @param str
     * @return
     */
    public static Integer str2Int(String str){

        Integer value = null;

        if(isEmpty(str)) return value;

        String newStr = str.replaceFirst("^0*", "");
        if (isNumeric(newStr)) {
            value = Integer.parseInt(newStr);
        }

        return value;
    }


    public static boolean contains(String value,String searchChars){
        if(isEmpty(value)||isEmpty(searchChars)){
            return false;
        }
        return value.contains(searchChars);
    }

    /**
     * 把以逗号分隔的字符串顺序转成List集合,去重
     *
     * @param ids
     * @return
     */
    public static List<Long> stringToListOrderByIds(String ids) {
        if (StringUtils.isEmpty(ids)){
            return Collections.emptyList();
        }
        String[] idStr = ids.split(SPLITTER);
        int len = idStr.length;
        List<Long> list = new ArrayList<>(len);
        for (String id : idStr) {
            String idTrim = id.trim();
            if (NumberUtils.isNumeric(idTrim)) {
                Long idLong = Long.valueOf(idTrim);
                if (!list.contains(idLong)) {
                    list.add(idLong);
                }
            } else {
                throw new QihoManagerException( "非法输入,id必须是数字");
            }
        }
        return list;
    }

    /**
     * 去除4字节的字符
     * @param content
     * @return
     */
    public static String removeFourChar(String content) {
        if (StringUtils.isBlank(content)) {
            return content;
        }
        byte[] conbyte = content.getBytes();
        int j = 0;
        for (int i = 0; i < conbyte.length; i++) {
            if (j == 0 && (conbyte[i] & 0xF8) == 0xF0) {
                j = 4;
            }
            if (j > 0) {
                conbyte[i] = 0x30;
                j--;
            }
        }
        String newContent = new String(conbyte);
        return newContent.replaceAll("0000", "");
    }

    /**
     * 校验字符串是否为纯中文
     *
     * @param str
     */
    public static boolean isFullChinese(String str) {
        String reg = "[\\u4e00-\\u9fa5]+";
        return str.matches(reg);
    }


    /**
     * 隐藏买家姓名信息
     * @param consumer
     * @return
     */
    public static String hideConsumerInfo(String consumer) {
        if (StringUtils.isNotBlank(consumer)) {
            String surname = consumer.substring(0,1);
            int length = consumer.length();
            return org.apache.commons.lang3.StringUtils.rightPad(surname, length, "*");
        }
        return consumer;
    }

    /**
     * 隐藏手机号信息
     * @param mobile
     * @return
     */
    public static String hideMobileInfo(String mobile){
        if (StringUtils.isNotBlank(mobile)) {
            return mobile.substring(0,3) + "********";
        }
        return mobile;
    }

}

