/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadResourceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadResourceUtil.class);

    private ReadResourceUtil() {
    }

    public static String readResource(String url) {
        if (StringUtils.isBlank((String)url)) {
            return "";
        }
        if (StringUtils.startsWith((String)url, (String)"//")) {
            url = "http:" + url;
        }
        if (!StringUtils.startsWith((String)url, (String)"http")) {
            url = "http://" + url;
        }
        try {
            ImmutableList lines = Resources.asCharSource((URL)new URL(url), (Charset)Charset.defaultCharset()).readLines();
            return Joiner.on((String)"").join((Iterable)lines);
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u8d44\u6e90\u5f02\u5e38\uff1aurl={}", (Object)url, (Object)e);
            return "";
        }
    }
}

