/*
 * Decompiled with CFR 0.152.
 */
package com.qiho.manager.common.util;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    private static final String PHONE_REG = "^(13[0-9]|14[5-9]|15[0-9]|166|17[0-8]|18[0-9]|19[8,9])[0-9]{8}$";
    private static final String ACCOUNT_REG = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{2,50}$";
    private static final String PD_REG = "^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,50}$";
    private static Pattern phonePattern = Pattern.compile("^(13[0-9]|14[5-9]|15[0-9]|166|17[0-8]|18[0-9]|19[8,9])[0-9]{8}$");
    private static Pattern pdPattern = Pattern.compile("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{6,50}$");
    private static Pattern accountPattern = Pattern.compile("^(?![0-9]+$)(?![a-zA-Z]+$)[0-9A-Za-z]{2,50}$");

    private ValidateUtil() {
    }

    public static boolean validPassword(String password) {
        if (StringUtils.isBlank((CharSequence)password)) {
            return Boolean.FALSE;
        }
        return pdPattern.matcher(password).matches();
    }

    public static boolean validPhoneNum(String phoneNum) {
        if (StringUtils.isBlank((CharSequence)phoneNum)) {
            return Boolean.FALSE;
        }
        return phonePattern.matcher(phoneNum).matches();
    }

    public static boolean validAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return Boolean.FALSE;
        }
        return accountPattern.matcher(account).matches();
    }
}

