/*
 * Decompiled with CFR 0.152.
 */
package com.rome.sign.core.util;

import com.rome.sign.core.SignData;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignCalculatorV1 {
    private static final Logger log = LoggerFactory.getLogger(SignCalculatorV1.class);
    private static final String HEADER_CLIENT = "X-Co-Client".toLowerCase();
    private static final String HEADER_TIMESTAMP = "X-Co-Timestamp".toLowerCase();
    private static final char EQUAL_SYMBOL = '=';
    private static final char AND_SYMBOL = '&';
    private static final char COLON_SYMBOL = ':';
    private static final char ENTER_SYMBOL = '\n';

    public static String calculateSign(SignData signData) {
        SignCalculatorV1.check(signData);
        String encoderData = signData.getMethod() + '\n' + signData.getPath();
        String queryString = SignCalculatorV1.canonicalQueryString(signData.getQueryParams());
        if (queryString != null && !"".equals(queryString)) {
            encoderData = encoderData + '\n' + queryString;
        }
        String headerString = SignCalculatorV1.canonicalHeader(signData.getClientId(), signData.getTimestamp());
        encoderData = encoderData + '\n' + headerString;
        if (signData.getMd5Body() != null && !"".equals(signData.getMd5Body())) {
            encoderData = encoderData + '\n' + signData.getMd5Body();
        }
        byte[] hmacSign = new byte[]{};
        try {
            SecretKeySpec secretKey = new SecretKeySpec(signData.getSecret().getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            hmacSign = mac.doFinal(encoderData.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception secretKey) {
            // empty catch block
        }
        Base64.Encoder encoder = Base64.getEncoder();
        String sign = encoder.encodeToString(hmacSign);
        if (log.isDebugEnabled()) {
            log.debug("\n-------------------------------\u5f85\u7b7e\u540d\u6570\u636e-------------------------------\n{}\n----------------------------------------------------------------------\n\u6570\u636e\u7b7e\u540d:[{}]", (Object)encoderData, (Object)sign);
        }
        return sign;
    }

    private static String canonicalQueryString(Map<String, String> parameter) {
        if (null != parameter && parameter.size() > 0) {
            Object[] keys = parameter.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                String value = String.valueOf(parameter.get(key));
                if (value == null || "".equals(value)) continue;
                if (i != 0) {
                    sb.append('&');
                }
                sb.append((String)key).append('=').append(URLEncoder.encode(value, "UTF-8"));
            }
            return sb.toString();
        }
        return null;
    }

    private static String canonicalHeader(String clientId, Long timestamp) {
        return HEADER_CLIENT + ':' + clientId.trim() + '\n' + HEADER_TIMESTAMP + ':' + timestamp;
    }

    private static void check(SignData signData) {
        if (signData.getClientId() == null || "".equals(signData.getClientId())) {
            throw new IllegalArgumentException("[clientId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signData.getSecret() == null || "".equals(signData.getSecret())) {
            throw new IllegalArgumentException("[secret]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signData.getTimestamp() == null) {
            throw new IllegalArgumentException("[timestamp]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signData.getMethod() == null || "".equals(signData.getMethod())) {
            throw new IllegalArgumentException("[method]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (signData.getPath() == null || "".equals(signData.getPath())) {
            throw new IllegalArgumentException("[path]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

