/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public final class MoreFutures {
    private MoreFutures() {
    }

    public static <V> void addCallback(@Nonnull ListenableFuture<V> future, final @Nonnull Consumer<V> success, final @Nonnull Consumer<Throwable> failure, @Nonnull Executor executor) {
        Preconditions.checkNotNull(future, (Object)"future");
        Preconditions.checkNotNull(success, (Object)"success");
        Preconditions.checkNotNull(failure, (Object)"failure");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        FutureCallback futureCallback = new FutureCallback<V>(){

            public void onSuccess(V result) {
                success.accept(result);
            }

            public void onFailure(Throwable t) {
                failure.accept(t);
            }
        };
        Futures.addCallback(future, (FutureCallback)futureCallback, (Executor)executor);
    }

    public static <V> void onSuccess(@Nonnull ListenableFuture<V> future, @Nonnull Consumer<V> success, @Nonnull Executor executor) {
        Preconditions.checkNotNull(future, (Object)"future");
        Preconditions.checkNotNull(success, (Object)"success");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        MoreFutures.addCallback(future, success, throwable -> {}, executor);
    }

    public static <V> void onFailure(@Nonnull ListenableFuture<V> future, @Nonnull Consumer<Throwable> failure, @Nonnull Executor executor) {
        Preconditions.checkNotNull(future, (Object)"future");
        Preconditions.checkNotNull(failure, (Object)"failure");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        MoreFutures.addCallback(future, v -> {}, failure, executor);
    }

    @Deprecated
    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState((boolean)future.isDone(), (String)"Future was expected to be done: %s", future);
        return (V)Uninterruptibles.getUninterruptibly(future);
    }

    @Deprecated
    public static <V> V getDoneUnchecked(Future<V> future) {
        Preconditions.checkState((boolean)future.isDone(), (String)"Future was expected to be done: %s", future);
        return (V)Futures.getUnchecked(future);
    }

    public static <V> CompletableFuture<V> toCompletableFuture(final @Nonnull ListenableFuture<V> listenableFuture) {
        Preconditions.checkNotNull(listenableFuture, (Object)"listenableFuture");
        CompletableFuture completableFuture = new CompletableFuture<V>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return super.cancel(mayInterruptIfRunning) && listenableFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean completeExceptionally(Throwable ex) {
                if (ex instanceof CancellationException) {
                    listenableFuture.cancel(true);
                }
                return super.completeExceptionally(ex);
            }
        };
        Runnable callbackRunnable = () -> {
            try {
                Object value = listenableFuture.get();
                completableFuture.complete(value);
            }
            catch (CancellationException ex) {
                completableFuture.cancel(true);
            }
            catch (ExecutionException ex) {
                completableFuture.completeExceptionally(ex.getCause());
            }
            catch (Error | RuntimeException ex) {
                completableFuture.completeExceptionally(ex);
            }
            catch (InterruptedException ex) {
                completableFuture.completeExceptionally(ex);
            }
        };
        listenableFuture.addListener(callbackRunnable, MoreExecutors.directExecutor());
        return completableFuture;
    }

    public static <V> ListenableFuture<V> fromCompletableFuture(final @Nonnull CompletableFuture<V> completableFuture) {
        Preconditions.checkNotNull(completableFuture, (Object)"completableFuture");
        Settable listenableFuture = new Settable<V>(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                return super.cancel(mayInterruptIfRunning) && completableFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean setException(Throwable ex) {
                if (ex instanceof CancellationException) {
                    completableFuture.cancel(true);
                }
                return super.setException(ex);
            }
        };
        completableFuture.whenComplete((value, ex) -> {
            if (value != null) {
                listenableFuture.set(value);
            } else if (ex instanceof CancellationException) {
                listenableFuture.cancel(true);
            } else {
                listenableFuture.setException((Throwable)ex);
            }
        });
        return listenableFuture;
    }

    private static class Settable<V>
    extends AbstractFuture<V> {
        private Settable() {
        }

        public boolean set(V value) {
            return super.set(value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }
    }
}

