/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.api.impl;

import com.sun.btrace.api.BTraceEngine;
import com.sun.btrace.api.BTraceTask;
import com.sun.btrace.api.impl.BTraceEngineImpl;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.GridDataCommand;
import com.sun.btrace.comm.MessageCommand;
import com.sun.btrace.comm.NumberDataCommand;
import com.sun.btrace.comm.NumberMapDataCommand;
import com.sun.btrace.comm.RetransformClassNotification;
import com.sun.btrace.comm.StringMapDataCommand;
import java.io.File;
import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BTraceTaskImpl
extends BTraceTask
implements BTraceEngineImpl.StateListener {
    private static final Pattern NAMED_EVENT_PATTERN = Pattern.compile("@OnEvent\\s*\\(\\s*\\\"(\\w.*)\\\"\\s*\\)", 8);
    private static final Pattern ANONYMOUS_EVENT_PATTERN = Pattern.compile("@OnEvent(?!\\s*\\()");
    private static final Pattern UNSAFE_PATTERN = Pattern.compile("@BTrace\\s*\\(.*unsafe\\s*=\\s*(true|false).*\\)", 8);
    private static final Pattern NAME_ANNOTATION_PATTERN = Pattern.compile("@BTrace\\s*\\(.*name\\s*=\\s*\"(.*)\".*\\)", 8);
    private static final Pattern NAME_PATTERN = Pattern.compile("@BTrace.*?class\\s+(.*?)\\s+", 8);
    private final AtomicReference<BTraceTask.State> currentState = new AtomicReference<BTraceTask.State>(BTraceTask.State.NEW);
    private final Set<BTraceTask.StateListener> stateListeners = new HashSet<BTraceTask.StateListener>();
    private final Set<BTraceTask.MessageDispatcher> messageDispatchers = new HashSet<BTraceTask.MessageDispatcher>();
    private static final ExecutorService dispatcher = Executors.newSingleThreadExecutor();
    private PrintWriter consoleWriter = new PrintWriter(System.out, true);
    private String script;
    private int numInstrClasses;
    private boolean unsafe;
    private final BTraceEngineImpl engine;
    private final int pid;

    public BTraceTaskImpl(int pid, BTraceEngine engine) {
        this.pid = pid;
        this.engine = (BTraceEngineImpl)engine;
        this.engine.addListener(this);
    }

    @Override
    public String getScript() {
        return this.script != null ? this.script : "";
    }

    @Override
    public String getName() {
        Matcher m = NAME_ANNOTATION_PATTERN.matcher(this.getScript());
        if (m.find()) {
            return m.group(1);
        }
        m = NAME_PATTERN.matcher(this.getScript());
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    @Override
    public void setScript(String newValue) {
        this.script = newValue;
        Matcher m = UNSAFE_PATTERN.matcher(this.getScript());
        if (m.find()) {
            this.unsafe = Boolean.parseBoolean(m.group(1));
        }
    }

    @Override
    public void sendEvent(String event) {
        this.engine.sendEvent(this, event);
    }

    @Override
    public void sendEvent() {
        this.engine.sendEvent(this);
    }

    @Override
    public Set<String> getNamedEvents() {
        HashSet<String> events = new HashSet<String>();
        Matcher matcher = NAMED_EVENT_PATTERN.matcher(this.getScript());
        while (matcher.find()) {
            events.add(matcher.group(1));
        }
        return events;
    }

    @Override
    public boolean hasAnonymousEvents() {
        Matcher matcher = ANONYMOUS_EVENT_PATTERN.matcher(this.getScript());
        return matcher.find();
    }

    @Override
    public boolean hasEvents() {
        return this.getScript() != null && this.getScript().contains("@OnEvent");
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    protected BTraceTask.State getState() {
        return this.currentState.get();
    }

    @Override
    public int getInstrClasses() {
        return EnumSet.of(BTraceTask.State.INSTRUMENTING, BTraceTask.State.RUNNING).contains((Object)this.getState()) ? this.numInstrClasses : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(BTraceTask.StateListener listener) {
        Set<BTraceTask.StateListener> set = this.stateListeners;
        synchronized (set) {
            this.stateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(BTraceTask.StateListener listener) {
        Set<BTraceTask.StateListener> set = this.stateListeners;
        synchronized (set) {
            this.stateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageDispatcher(BTraceTask.MessageDispatcher dispatcher) {
        Set<BTraceTask.MessageDispatcher> set = this.messageDispatchers;
        synchronized (set) {
            this.messageDispatchers.add(dispatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageDispatcher(BTraceTask.MessageDispatcher dispatcher) {
        Set<BTraceTask.MessageDispatcher> set = this.messageDispatchers;
        synchronized (set) {
            this.messageDispatchers.remove(dispatcher);
        }
    }

    @Override
    public void start() {
        this.setState(BTraceTask.State.STARTING);
        if (!this.engine.start(this)) {
            this.setState(BTraceTask.State.FAILED);
        }
    }

    @Override
    public void stop() {
        if (this.getState() == BTraceTask.State.RUNNING && !this.engine.stop(this)) {
            this.setState(BTraceTask.State.RUNNING);
        }
    }

    @Override
    public void onTaskStart(BTraceTask task) {
        if (task.equals(this)) {
            this.setState(BTraceTask.State.RUNNING);
        }
    }

    @Override
    public void onTaskStop(BTraceTask task) {
        if (task.equals(this)) {
            this.setState(BTraceTask.State.FINISHED);
        }
    }

    @Override
    public String getClassPath() {
        StringBuilder sb = new StringBuilder();
        for (String cpEntry : this.engine.getClasspathProvider().getClasspath(this)) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(cpEntry);
        }
        return sb.toString();
    }

    @Override
    public boolean isUnsafe() {
        return this.unsafe;
    }

    void setState(BTraceTask.State newValue) {
        this.currentState.set(newValue);
        this.fireStateChange();
    }

    void setInstrClasses(int value) {
        this.numInstrClasses = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateChange() {
        HashSet<BTraceTask.StateListener> toProcess = null;
        Set<BTraceTask.StateListener> set = this.stateListeners;
        synchronized (set) {
            toProcess = new HashSet<BTraceTask.StateListener>(this.stateListeners);
        }
        for (BTraceTask.StateListener listener : toProcess) {
            listener.stateChanged(this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchCommand(final Command cmd) {
        final HashSet<BTraceTask.MessageDispatcher> dispatchingSet = new HashSet<BTraceTask.MessageDispatcher>();
        Set<BTraceTask.MessageDispatcher> set = this.messageDispatchers;
        synchronized (set) {
            dispatchingSet.addAll(this.messageDispatchers);
        }
        dispatcher.submit(new Runnable(){

            @Override
            public void run() {
                for (BTraceTask.MessageDispatcher listener : dispatchingSet) {
                    switch (cmd.getType()) {
                        case 4: {
                            listener.onPrintMessage(((MessageCommand)cmd).getMessage());
                            break;
                        }
                        case 12: {
                            listener.onClassInstrumented(((RetransformClassNotification)cmd).getClassName());
                            break;
                        }
                        case 9: {
                            NumberDataCommand ndc = (NumberDataCommand)cmd;
                            listener.onNumberMessage(ndc.getName(), ndc.getValue());
                            break;
                        }
                        case 7: {
                            NumberMapDataCommand nmdc = (NumberMapDataCommand)cmd;
                            listener.onNumberMap(nmdc.getName(), nmdc.getData());
                            break;
                        }
                        case 8: {
                            StringMapDataCommand smdc = (StringMapDataCommand)cmd;
                            listener.onStringMap(smdc.getName(), smdc.getData());
                            break;
                        }
                        case 10: {
                            GridDataCommand gdc = (GridDataCommand)cmd;
                            listener.onGrid(gdc.getName(), gdc.getData());
                            break;
                        }
                        case 0: {
                            ErrorCommand ec = (ErrorCommand)cmd;
                            listener.onError(ec.getCause());
                            break;
                        }
                    }
                }
            }
        });
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BTraceTaskImpl other = (BTraceTaskImpl)obj;
        if (this.pid != other.pid) {
            return false;
        }
        return this.getName() == other.getName() || this.getName() != null && this.getName().equals(other.getName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + this.pid;
        hash = 19 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        return hash;
    }
}

