/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace.client;

import com.sun.btrace.CommandListener;
import com.sun.btrace.client.Client;
import com.sun.btrace.comm.Command;
import com.sun.btrace.comm.DataCommand;
import com.sun.btrace.comm.ErrorCommand;
import com.sun.btrace.comm.ExitCommand;
import com.sun.btrace.util.Messages;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public final class Main {
    public static volatile boolean exiting;
    public static final boolean DEBUG;
    public static final boolean TRACK_RETRANSFORM;
    public static final boolean UNSAFE;
    public static final boolean DUMP_CLASSES;
    public static final String DUMP_DIR;
    public static final String PROBE_DESC_PATH;
    public static final int BTRACE_DEFAULT_PORT = 2020;
    private static final Console con;
    private static final PrintWriter out;

    public static void main(String[] args) {
        if (args.length < 2) {
            Main.usage();
        }
        int port = 2020;
        String classPath = ".";
        String includePath = null;
        int count = 0;
        boolean portDefined = false;
        boolean classpathDefined = false;
        boolean includePathDefined = false;
        while (args[count].charAt(0) == '-') {
            if (args.length <= count + 1) {
                Main.usage();
            }
            if (args[count].equals("-p") && !portDefined) {
                try {
                    port = Integer.parseInt(args[++count]);
                    if (Main.isDebug()) {
                        Main.debugPrint("accepting port " + port);
                    }
                }
                catch (NumberFormatException nfe) {
                    Main.usage();
                }
                portDefined = true;
            } else if ((args[count].equals("-cp") || args[count].equals("-classpath")) && !classpathDefined) {
                classPath = args[++count];
                if (Main.isDebug()) {
                    Main.debugPrint("accepting classpath " + classPath);
                }
                classpathDefined = true;
            } else if (args[count].equals("-I") && !includePathDefined) {
                includePath = args[++count];
                if (Main.isDebug()) {
                    Main.debugPrint("accepting include path " + includePath);
                }
                includePathDefined = true;
            } else {
                Main.usage();
            }
            if (++count < args.length) continue;
        }
        if (!portDefined && Main.isDebug()) {
            Main.debugPrint("assuming default port " + port);
        }
        if (!classpathDefined && Main.isDebug()) {
            Main.debugPrint("assuming default classpath '" + classPath + "'");
        }
        if (args.length < count + 1) {
            Main.usage();
        }
        String pid = args[count];
        String fileName = args[count + 1];
        String[] btraceArgs = new String[args.length - count];
        if (btraceArgs.length > 0) {
            System.arraycopy(args, count, btraceArgs, 0, btraceArgs.length);
        }
        try {
            byte[] code;
            Client client = new Client(port, PROBE_DESC_PATH, DEBUG, TRACK_RETRANSFORM, UNSAFE, DUMP_CLASSES, DUMP_DIR);
            if (!new File(fileName).exists()) {
                Main.errorExit("File not found: " + fileName, 1);
            }
            if ((code = client.compile(fileName, classPath, includePath)) == null) {
                Main.errorExit("BTrace compilation failed", 1);
            }
            client.attach(pid);
            Main.registerExitHook(client);
            if (con != null) {
                Main.registerSignalHandler(client);
            }
            if (Main.isDebug()) {
                Main.debugPrint("submitting the BTrace program");
            }
            client.submit(fileName, code, btraceArgs, Main.createCommandListener(client));
        }
        catch (IOException exp) {
            Main.errorExit(exp.getMessage(), 1);
        }
    }

    private static CommandListener createCommandListener(Client client) {
        return new CommandListener(){

            @Override
            public void onCommand(Command cmd) throws IOException {
                ErrorCommand ecmd;
                Throwable cause;
                byte type = cmd.getType();
                if (cmd instanceof DataCommand) {
                    ((DataCommand)cmd).print(out);
                    out.flush();
                } else if (type == 2) {
                    exiting = true;
                    ExitCommand ecmd2 = (ExitCommand)cmd;
                    System.exit(ecmd2.getExitCode());
                } else if (type == 0 && (cause = (ecmd = (ErrorCommand)cmd).getCause()) != null) {
                    cause.printStackTrace();
                }
            }
        };
    }

    private static void registerExitHook(final Client client) {
        if (Main.isDebug()) {
            Main.debugPrint("registering shutdown hook");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                block4: {
                    if (!exiting) {
                        try {
                            if (Main.isDebug()) {
                                Main.debugPrint("sending exit command");
                            }
                            client.sendExit(0);
                        }
                        catch (IOException ioexp) {
                            if (!Main.isDebug()) break block4;
                            Main.debugPrint(ioexp.toString());
                        }
                    }
                }
            }
        }));
    }

    private static void registerSignalHandler(final Client client) {
        if (Main.isDebug()) {
            Main.debugPrint("registering signal handler for SIGINT");
        }
        Signal.handle(new Signal("INT"), new SignalHandler(){

            @Override
            public void handle(Signal sig) {
                block12: {
                    try {
                        con.printf("Please enter your option:\n", new Object[0]);
                        con.printf("\t1. exit\n\t2. send an event\n\t3. send a named event\n", new Object[0]);
                        con.flush();
                        String option = con.readLine();
                        option = option.trim();
                        if (option == null) {
                            return;
                        }
                        if (option.equals("1")) {
                            System.exit(0);
                        } else if (option.equals("2")) {
                            if (Main.isDebug()) {
                                Main.debugPrint("sending event command");
                            }
                            client.sendEvent();
                        } else if (option.equals("3")) {
                            con.printf("Please enter the event name: ", new Object[0]);
                            String name = con.readLine();
                            if (name != null) {
                                if (Main.isDebug()) {
                                    Main.debugPrint("sending event command");
                                }
                                client.sendEvent(name);
                            }
                        } else {
                            con.printf("invalid option!\n", new Object[0]);
                        }
                    }
                    catch (IOException ioexp) {
                        if (!Main.isDebug()) break block12;
                        Main.debugPrint(ioexp.toString());
                    }
                }
            }
        });
    }

    private static void usage() {
        System.err.println(Messages.get("btrace.usage"));
        System.exit(1);
    }

    private static boolean isDebug() {
        return DEBUG;
    }

    private static boolean isUnsafe() {
        return UNSAFE;
    }

    private static void debugPrint(String msg) {
        System.out.println("DEBUG: " + msg);
    }

    private static void errorExit(String msg, int code) {
        exiting = true;
        System.err.println(msg);
        System.exit(code);
    }

    static {
        DEBUG = Boolean.getBoolean("com.sun.btrace.debug");
        if (Main.isDebug()) {
            Main.debugPrint("btrace debug mode is set");
        }
        TRACK_RETRANSFORM = Boolean.getBoolean("com.sun.btrace.trackRetransforms");
        if (Main.isDebug() && TRACK_RETRANSFORM) {
            Main.debugPrint("trackRetransforms flag is set");
        }
        UNSAFE = Boolean.getBoolean("com.sun.btrace.unsafe");
        if (Main.isDebug() && UNSAFE) {
            Main.debugPrint("btrace unsafe mode is set");
        }
        DUMP_CLASSES = Boolean.getBoolean("com.sun.btrace.dumpClasses");
        if (Main.isDebug() && DUMP_CLASSES) {
            Main.debugPrint("dumpClasses flag is set");
        }
        DUMP_DIR = System.getProperty("com.sun.btrace.dumpDir", ".");
        if (DUMP_CLASSES && Main.isDebug()) {
            Main.debugPrint("dumpDir is " + DUMP_DIR);
        }
        PROBE_DESC_PATH = System.getProperty("com.sun.btrace.probeDescPath", ".");
        con = System.console();
        out = con != null ? con.writer() : new PrintWriter(System.out);
    }
}

