package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * sku详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public class ArticleItemViewUnit extends TaobaoObject {

	private static final long serialVersionUID = 2553231393963163621L;

	/**
	 * 需要支付的价格，单位：元
	 */
	@ApiField("actual_price")
	private String actualPrice;

	/**
	 * 用户是否可以购买
	 */
	@ApiField("can_sub")
	private Boolean canSub;

	/**
	 * 周期数，如1，3，6，12。对于周期型和周期计量型返回。
	 */
	@ApiField("cyc_num")
	private Long cycNum;

	/**
	 * 1-年，2-月，3-日。对于周期型和周期计量型返回。
	 */
	@ApiField("cyc_unit")
	private Long cycUnit;

	/**
	 * 错误码
	 */
	@ApiField("error_code")
	private String errorCode;

	/**
	 * 错误文案
	 */
	@ApiField("error_msg")
	private String errorMsg;

	/**
	 * 收费项目code
	 */
	@ApiField("item_code")
	private String itemCode;

	/**
	 * 收费项目名称
	 */
	@ApiField("item_name")
	private String itemName;

	/**
	 * 原价，单位：元
	 */
	@ApiField("origin_price")
	private String originPrice;

	/**
	 * 优惠，单位：元
	 */
	@ApiField("prom_price")
	private String promPrice;

	/**
	 * 数量。对于周期计量型返回计量数。
	 */
	@ApiField("quantity")
	private Long quantity;


	public String getActualPrice() {
		return this.actualPrice;
	}
	public void setActualPrice(String actualPrice) {
		this.actualPrice = actualPrice;
	}

	public Boolean getCanSub() {
		return this.canSub;
	}
	public void setCanSub(Boolean canSub) {
		this.canSub = canSub;
	}

	public Long getCycNum() {
		return this.cycNum;
	}
	public void setCycNum(Long cycNum) {
		this.cycNum = cycNum;
	}

	public Long getCycUnit() {
		return this.cycUnit;
	}
	public void setCycUnit(Long cycUnit) {
		this.cycUnit = cycUnit;
	}

	public String getErrorCode() {
		return this.errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMsg() {
		return this.errorMsg;
	}
	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getItemCode() {
		return this.itemCode;
	}
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getItemName() {
		return this.itemName;
	}
	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getOriginPrice() {
		return this.originPrice;
	}
	public void setOriginPrice(String originPrice) {
		this.originPrice = originPrice;
	}

	public String getPromPrice() {
		return this.promPrice;
	}
	public void setPromPrice(String promPrice) {
		this.promPrice = promPrice;
	}

	public Long getQuantity() {
		return this.quantity;
	}
	public void setQuantity(Long quantity) {
		this.quantity = quantity;
	}

}
