package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;


/**
 * 服务详情
 *
 * @author top auto create
 * @since 1.0, null
 */
public class ArticleViewResult extends TaobaoObject {

	private static final long serialVersionUID = 6356255763149167415L;

	/**
	 * 服务code
	 */
	@ApiField("article_code")
	private String articleCode;

	/**
	 * 服务简介
	 */
	@ApiField("article_commment")
	private String articleCommment;

	/**
	 * sku详情列表
	 */
	@ApiListField("article_item_view_units")
	@ApiField("article_item_view_unit")
	private List<ArticleItemViewUnit> articleItemViewUnits;

	/**
	 * 服务名称
	 */
	@ApiField("article_name")
	private String articleName;

	/**
	 * 错误码
	 */
	@ApiField("error_code")
	private String errorCode;

	/**
	 * 错误消息
	 */
	@ApiField("error_msg")
	private String errorMsg;

	/**
	 * 用户淘宝nick
	 */
	@ApiField("nick")
	private String nick;

	/**
	 * 服务图片地址
	 */
	@ApiField("pict_url")
	private String pictUrl;


	public String getArticleCode() {
		return this.articleCode;
	}
	public void setArticleCode(String articleCode) {
		this.articleCode = articleCode;
	}

	public String getArticleCommment() {
		return this.articleCommment;
	}
	public void setArticleCommment(String articleCommment) {
		this.articleCommment = articleCommment;
	}

	public List<ArticleItemViewUnit> getArticleItemViewUnits() {
		return this.articleItemViewUnits;
	}
	public void setArticleItemViewUnits(List<ArticleItemViewUnit> articleItemViewUnits) {
		this.articleItemViewUnits = articleItemViewUnits;
	}

	public String getArticleName() {
		return this.articleName;
	}
	public void setArticleName(String articleName) {
		this.articleName = articleName;
	}

	public String getErrorCode() {
		return this.errorCode;
	}
	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMsg() {
		return this.errorMsg;
	}
	public void setErrorMsg(String errorMsg) {
		this.errorMsg = errorMsg;
	}

	public String getNick() {
		return this.nick;
	}
	public void setNick(String nick) {
		this.nick = nick;
	}

	public String getPictUrl() {
		return this.pictUrl;
	}
	public void setPictUrl(String pictUrl) {
		this.pictUrl = pictUrl;
	}

}
