package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;


/**
 * 买家淘金币查询结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public class BuyerDetailQueryList extends TaobaoObject {

	private static final long serialVersionUID = 3298417388859776424L;

	/**
	 * 当前页
	 */
	@ApiField("current_page")
	private Long currentPage;

	/**
	 * 列表
	 */
	@ApiListField("list")
	@ApiField("open_coin_detail")
	private List<OpenCoinDetail> list;

	/**
	 * 总条数
	 */
	@ApiField("total_count")
	private Long totalCount;

	/**
	 * 总页数
	 */
	@ApiField("total_page")
	private Long totalPage;


	public Long getCurrentPage() {
		return this.currentPage;
	}
	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public List<OpenCoinDetail> getList() {
		return this.list;
	}
	public void setList(List<OpenCoinDetail> list) {
		this.list = list;
	}

	public Long getTotalCount() {
		return this.totalCount;
	}
	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}

	public Long getTotalPage() {
		return this.totalPage;
	}
	public void setTotalPage(Long totalPage) {
		this.totalPage = totalPage;
	}

}
