package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;


/**
 * 查询结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public class DetailQueryList extends TaobaoObject {

	private static final long serialVersionUID = 5282859846787892295L;

	/**
	 * 当前页码
	 */
	@ApiField("current_page")
	private Long currentPage;

	/**
	 * 明细列表
	 */
	@ApiListField("list")
	@ApiField("open_coin_biz_detail")
	private List<OpenCoinBizDetail> list;

	/**
	 * 总记录数
	 */
	@ApiField("total_count")
	private Long totalCount;

	/**
	 * 总页数
	 */
	@ApiField("total_page")
	private Long totalPage;


	public Long getCurrentPage() {
		return this.currentPage;
	}
	public void setCurrentPage(Long currentPage) {
		this.currentPage = currentPage;
	}

	public List<OpenCoinBizDetail> getList() {
		return this.list;
	}
	public void setList(List<OpenCoinBizDetail> list) {
		this.list = list;
	}

	public Long getTotalCount() {
		return this.totalCount;
	}
	public void setTotalCount(Long totalCount) {
		this.totalCount = totalCount;
	}

	public Long getTotalPage() {
		return this.totalPage;
	}
	public void setTotalPage(Long totalPage) {
		this.totalPage = totalPage;
	}

}
