package com.taobao.api.domain;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Date;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 开放的卖家淘金币明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public class OpenCoinBizDetail extends TaobaoObject {

	private static final long serialVersionUID = 8428698488681685222L;

	/**
	 * 活动名称
	 */
	@ApiField("activity_title")
	private String activityTitle;

	/**
	 * 发生的金币数，正数表示收入，负数表示支出。
	 */
	@ApiField("amount")
	private Long amount;

	/**
	 * 外部扩展属性
	 */
	@ApiField("attributes")
	private String attributes;

	/**
	 * 备注
	 */
	@ApiField("comments")
	private String comments;

	/**
	 * 创建时间
	 */
	@ApiField("gmt_create")
	private Date gmtCreate;

	/**
	 * 修改时间
	 */
	@ApiField("gmt_modified")
	private Date gmtModified;

	/**
	 * 主键ID
	 */
	@ApiField("id")
	private Long id;

	/**
	 * 匿名方式NICK
	 */
	@ApiField("nick")
	private String nick;

	/**
	 * 明细关联的外键ID
	 */
	@ApiField("out_id")
	private Long outId;

	/**
	 * 淘金币平台活动ID
	 */
	@ApiField("tb_activity_id")
	private Long tbActivityId;


	public String getActivityTitle() {
		return this.activityTitle;
	}
	public void setActivityTitle(String activityTitle) {
		this.activityTitle = activityTitle;
	}

	public Long getAmount() {
		return this.amount;
	}
	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public String getAttributes() {
		return this.attributes;
	}
	public void setAttributes(String attributes) {
		this.attributes = attributes;
	}
	public void setAttributesString(String attributes) {
		this.attributes = attributes;
	}
	

	public String getComments() {
		return this.comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getGmtCreate() {
		return this.gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return this.gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Long getId() {
		return this.id;
	}
	public void setId(Long id) {
		this.id = id;
	}

	public String getNick() {
		return this.nick;
	}
	public void setNick(String nick) {
		this.nick = nick;
	}

	public Long getOutId() {
		return this.outId;
	}
	public void setOutId(Long outId) {
		this.outId = outId;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}
	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

}
