package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiListField;


/**
 * 套餐对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public class OpenMealDo extends TaobaoObject {

	private static final long serialVersionUID = 5864119519496935322L;

	/**
	 * 套餐结束时间戳
	 */
	@ApiField("end_time")
	private String endTime;

	/**
	 * 手淘购买链接
	 */
	@ApiField("h5_buy_url")
	private String h5BuyUrl;

	/**
	 * 套餐商品列表
	 */
	@ApiListField("items")
	@ApiField("open_meal_item_do")
	private List<OpenMealItemDo> items;

	/**
	 * 套餐名称
	 */
	@ApiField("meal_name")
	private String mealName;

	/**
	 * 单位分，套餐总价
	 */
	@ApiField("meal_price")
	private Long mealPrice;

	/**
	 * 套餐开始时间戳
	 */
	@ApiField("start_time")
	private String startTime;


	public String getEndTime() {
		return this.endTime;
	}
	public void setEndTime(String endTime) {
		this.endTime = endTime;
	}

	public String getH5BuyUrl() {
		return this.h5BuyUrl;
	}
	public void setH5BuyUrl(String h5BuyUrl) {
		this.h5BuyUrl = h5BuyUrl;
	}

	public List<OpenMealItemDo> getItems() {
		return this.items;
	}
	public void setItems(List<OpenMealItemDo> items) {
		this.items = items;
	}

	public String getMealName() {
		return this.mealName;
	}
	public void setMealName(String mealName) {
		this.mealName = mealName;
	}

	public Long getMealPrice() {
		return this.mealPrice;
	}
	public void setMealPrice(Long mealPrice) {
		this.mealPrice = mealPrice;
	}

	public String getStartTime() {
		return this.startTime;
	}
	public void setStartTime(String startTime) {
		this.startTime = startTime;
	}

}
