package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 内购服务下单接口参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public class OrderConfirmQueryDto extends TaobaoObject {

	private static final long serialVersionUID = 4821775931262869118L;

	/**
	 * APPKEY，必填
	 */
	@ApiField("app_key")
	private String appKey;

	/**
	 * 周期数量，必填
	 */
	@ApiField("cyc_num")
	private String cycNum;

	/**
	 * 周期单位(必选 数值1:年 2:月， 3：天)，必填
	 */
	@ApiField("cyc_unit")
	private String cycUnit;

	/**
	 * 设备类型，目前只支持PC，可选
	 */
	@ApiField("device_type")
	private String deviceType;

	/**
	 * 内购服务的规格CODE，必填
	 */
	@ApiField("item_code")
	private String itemCode;

	/**
	 * 使用该参数完成查询订单等操作，可选
	 */
	@ApiField("out_trade_code")
	private String outTradeCode;

	/**
	 * 计量型服务的数量，如果是计量型内购服务，则必填
	 */
	@ApiField("quantity")
	private String quantity;


	public String getAppKey() {
		return this.appKey;
	}
	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getCycNum() {
		return this.cycNum;
	}
	public void setCycNum(String cycNum) {
		this.cycNum = cycNum;
	}

	public String getCycUnit() {
		return this.cycUnit;
	}
	public void setCycUnit(String cycUnit) {
		this.cycUnit = cycUnit;
	}

	public String getDeviceType() {
		return this.deviceType;
	}
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}

	public String getItemCode() {
		return this.itemCode;
	}
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getOutTradeCode() {
		return this.outTradeCode;
	}
	public void setOutTradeCode(String outTradeCode) {
		this.outTradeCode = outTradeCode;
	}

	public String getQuantity() {
		return this.quantity;
	}
	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

}
