package com.taobao.api.domain;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Date;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 淘金币活动
 *
 * @author top auto create
 * @since 1.0, null
 */
public class ThirdActivity extends TaobaoObject {

	private static final long serialVersionUID = 7865157397898967614L;

	/**
	 * 活动标题
	 */
	@ApiField("activity_title")
	private String activityTitle;

	/**
	 * 参与活动入口URL
	 */
	@ApiField("activity_url")
	private String activityUrl;

	/**
	 * AppKey
	 */
	@ApiField("app_key")
	private String appKey;

	/**
	 * 为活动冻结的金币数余额
	 */
	@ApiField("budget_amount")
	private Long budgetAmount;

	/**
	 * 活动结束时间
	 */
	@ApiField("end_time")
	private Date endTime;

	/**
	 * 外部扩展属性
	 */
	@ApiField("feature")
	private String feature;

	/**
	 * 外部活动ID
	 */
	@ApiField("out_activity_id")
	private Long outActivityId;

	/**
	 * 卖家ID
	 */
	@ApiField("seller_id")
	private Long sellerId;

	/**
	 * 活动开始时间
	 */
	@ApiField("start_time")
	private Date startTime;

	/**
	 * 状态，0-有效状态，-1-创建失败，-2-卖家中止, -3-系统中止, -4-到期终止
	 */
	@ApiField("status")
	private Long status;

	/**
	 * 淘金币活动ID
	 */
	@ApiField("tb_activity_id")
	private Long tbActivityId;


	public String getActivityTitle() {
		return this.activityTitle;
	}
	public void setActivityTitle(String activityTitle) {
		this.activityTitle = activityTitle;
	}

	public String getActivityUrl() {
		return this.activityUrl;
	}
	public void setActivityUrl(String activityUrl) {
		this.activityUrl = activityUrl;
	}

	public String getAppKey() {
		return this.appKey;
	}
	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public Long getBudgetAmount() {
		return this.budgetAmount;
	}
	public void setBudgetAmount(Long budgetAmount) {
		this.budgetAmount = budgetAmount;
	}

	public Date getEndTime() {
		return this.endTime;
	}
	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public String getFeature() {
		return this.feature;
	}
	public void setFeature(String feature) {
		this.feature = feature;
	}
	public void setFeatureString(String feature) {
		this.feature = feature;
	}
	

	public Long getOutActivityId() {
		return this.outActivityId;
	}
	public void setOutActivityId(Long outActivityId) {
		this.outActivityId = outActivityId;
	}

	public Long getSellerId() {
		return this.sellerId;
	}
	public void setSellerId(Long sellerId) {
		this.sellerId = sellerId;
	}

	public Date getStartTime() {
		return this.startTime;
	}
	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Long getStatus() {
		return this.status;
	}
	public void setStatus(Long status) {
		this.status = status;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}
	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

}
