package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractActivityAddcommentResponse;

/**
 * TOP API: alibaba.interact.activity.addcomment request
 * 
 * @author top auto create
 * @since 1.0, 2015.10.12
 */
public class AlibabaInteractActivityAddcommentRequest extends BaseTaobaoRequest<AlibabaInteractActivityAddcommentResponse> {
	
	

	/** 
	* 发评论的业务id
	 */
	private String bizId;

	/** 
	* 该字段为评论内容
	 */
	private String content;

	/** 
	* 评论feedid
	 */
	private Long feedId;

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getContent() {
		return this.content;
	}

	public void setFeedId(Long feedId) {
		this.feedId = feedId;
	}

	public Long getFeedId() {
		return this.feedId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.activity.addcomment";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("content", this.content);
		txtParams.put("feed_id", this.feedId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractActivityAddcommentResponse> getResponseClass() {
		return AlibabaInteractActivityAddcommentResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(content, "content");
		RequestCheckUtils.checkNotEmpty(feedId, "feedId");
	}
	

}