package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractActivityApplyResponse;

/**
 * TOP API: alibaba.interact.activity.apply request
 * 
 * @author top auto create
 * @since 1.0, 2016.11.11
 */
public class AlibabaInteractActivityApplyRequest extends BaseTaobaoRequest<AlibabaInteractActivityApplyResponse> {
	
	

	/** 
	* 报名参加中心化流量活动的活动id
	 */
	private String activityBizId;

	/** 
	* 报名参加的中心化流量活动的banner 地址
	 */
	private String bannerUrl;

	/** 
	* 权益总额
	 */
	private String benefitAmount;

	/** 
	* 权益属性(如红包，则为relationid)
	 */
	private String benefitAttribute;

	/** 
	* 权益对应的面额
	 */
	private String benefitDenomination;

	/** 
	* 活动发放的权益类型，1:支付宝红包2:流量包3:淘金币4:集分宝5:优惠卷
	 */
	private String benefitType;

	/** 
	* 该活动参与的中心化流量活动。1:代表每日赢宝箱2:微淘广场
	 */
	private String bizType;

	public void setActivityBizId(String activityBizId) {
		this.activityBizId = activityBizId;
	}

	public String getActivityBizId() {
		return this.activityBizId;
	}

	public void setBannerUrl(String bannerUrl) {
		this.bannerUrl = bannerUrl;
	}

	public String getBannerUrl() {
		return this.bannerUrl;
	}

	public void setBenefitAmount(String benefitAmount) {
		this.benefitAmount = benefitAmount;
	}

	public String getBenefitAmount() {
		return this.benefitAmount;
	}

	public void setBenefitAttribute(String benefitAttribute) {
		this.benefitAttribute = benefitAttribute;
	}

	public String getBenefitAttribute() {
		return this.benefitAttribute;
	}

	public void setBenefitDenomination(String benefitDenomination) {
		this.benefitDenomination = benefitDenomination;
	}

	public String getBenefitDenomination() {
		return this.benefitDenomination;
	}

	public void setBenefitType(String benefitType) {
		this.benefitType = benefitType;
	}

	public String getBenefitType() {
		return this.benefitType;
	}

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public String getApiMethodName() {
		return "alibaba.interact.activity.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_biz_id", this.activityBizId);
		txtParams.put("banner_url", this.bannerUrl);
		txtParams.put("benefit_amount", this.benefitAmount);
		txtParams.put("benefit_attribute", this.benefitAttribute);
		txtParams.put("benefit_denomination", this.benefitDenomination);
		txtParams.put("benefit_type", this.benefitType);
		txtParams.put("biz_type", this.bizType);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractActivityApplyResponse> getResponseClass() {
		return AlibabaInteractActivityApplyResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityBizId, "activityBizId");
		RequestCheckUtils.checkNotEmpty(bannerUrl, "bannerUrl");
		RequestCheckUtils.checkNotEmpty(benefitAttribute, "benefitAttribute");
		RequestCheckUtils.checkNotEmpty(benefitType, "benefitType");
		RequestCheckUtils.checkNotEmpty(bizType, "bizType");
	}
	

}