package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractActivityRegisterResponse;

/**
 * TOP API: alibaba.interact.activity.register request
 * 
 * @author top auto create
 * @since 1.0, 2015.04.08
 */
public class AlibabaInteractActivityRegisterRequest extends BaseTaobaoRequest<AlibabaInteractActivityRegisterResponse> {
	
	

	/** 
	* 活动ID
	 */
	private String bizId;

	/** 
	* 活动描述文字
	 */
	private String description;

	/** 
	* 活动结束时间
	 */
	private Date endTime;

	/** 
	* 页面内容链接，仅允许ascii字符
	 */
	private String entryUrl;

	/** 
	* 是否有有效时间，若为真开始时间和结束时间必填，默认为真
	 */
	private Boolean hasValidTime;

	/** 
	* 活动名称
	 */
	private String name;

	/** 
	* 活动封面图片（非必填）
	 */
	private String picture;

	/** 
	* 活动开始时间
	 */
	private Date startTime;

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getDescription() {
		return this.description;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setEntryUrl(String entryUrl) {
		this.entryUrl = entryUrl;
	}

	public String getEntryUrl() {
		return this.entryUrl;
	}

	public void setHasValidTime(Boolean hasValidTime) {
		this.hasValidTime = hasValidTime;
	}

	public Boolean getHasValidTime() {
		return this.hasValidTime;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return this.name;
	}

	public void setPicture(String picture) {
		this.picture = picture;
	}

	public String getPicture() {
		return this.picture;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "alibaba.interact.activity.register";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		txtParams.put("description", this.description);
		txtParams.put("end_time", this.endTime);
		txtParams.put("entry_url", this.entryUrl);
		txtParams.put("has_valid_time", this.hasValidTime);
		txtParams.put("name", this.name);
		txtParams.put("picture", this.picture);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractActivityRegisterResponse> getResponseClass() {
		return AlibabaInteractActivityRegisterResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
		RequestCheckUtils.checkNotEmpty(entryUrl, "entryUrl");
		RequestCheckUtils.checkNotEmpty(hasValidTime, "hasValidTime");
		RequestCheckUtils.checkNotEmpty(name, "name");
	}
	

}