package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractActivityUnregisterResponse;

/**
 * TOP API: alibaba.interact.activity.unregister request
 * 
 * @author top auto create
 * @since 1.0, 2015.06.12
 */
public class AlibabaInteractActivityUnregisterRequest extends BaseTaobaoRequest<AlibabaInteractActivityUnregisterResponse> {
	
	

	/** 
	* 互动活动ID
	 */
	private String bizId;

	public void setBizId(String bizId) {
		this.bizId = bizId;
	}

	public String getBizId() {
		return this.bizId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.activity.unregister";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_id", this.bizId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractActivityUnregisterResponse> getResponseClass() {
		return AlibabaInteractActivityUnregisterResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(bizId, "bizId");
	}
	

}