package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaInteractAopdataRegisterResponse;

/**
 * TOP API: alibaba.interact.aopdata.register request
 * 
 * @author top auto create
 * @since 1.0, 2016.01.27
 */
public class AlibabaInteractAopdataRegisterRequest extends BaseTaobaoRequest<AlibabaInteractAopdataRegisterResponse> {
	
	

	/** 
	* 入参
	 */
	private String paramTopIsvDecorateParam;

	public void setParamTopIsvDecorateParam(String paramTopIsvDecorateParam) {
		this.paramTopIsvDecorateParam = paramTopIsvDecorateParam;
	}

	public void setParamTopIsvDecorateParam(TopIsvDecorateParam paramTopIsvDecorateParam) {
		this.paramTopIsvDecorateParam = new JSONWriter(false,true).write(paramTopIsvDecorateParam);
	}

	public String getParamTopIsvDecorateParam() {
		return this.paramTopIsvDecorateParam;
	}

	public String getApiMethodName() {
		return "alibaba.interact.aopdata.register";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_top_isv_decorate_param", this.paramTopIsvDecorateParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractAopdataRegisterResponse> getResponseClass() {
		return AlibabaInteractAopdataRegisterResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopIsvDecorateParam extends TaobaoObject {

	private static final long serialVersionUID = 2396647733163879893L;

	/**
		 * 活动id，调用alibaba.interact.activity.register传入的bizid
		 */
		@ApiField("biz_id")
		private String bizId;
		/**
		 * 目前必须填0，代表店铺
		 */
		@ApiField("biz_type")
		private String bizType;
		/**
		 * {"action":"update","image_url":"http://xx.cdn","click_url":"http://xxx.play.m.jaeapp.com"}，action为update，代表新增(image_url以及click_url必传)。action=get，代表获得商家设置的活动，image_url以及click_url不用填写。action＝del,代表将活动从资源位撤下
		 */
		@ApiField("business_params")
		private String businessParams;
		/**
		 * 不用传
		 */
		@ApiField("position")
		private String position;
		/**
		 * 目前必须填0，代表店铺中宝箱资源位
		 */
		@ApiField("sub_biz_type")
		private String subBizType;
	

	public String getBizId() {
			return this.bizId;
		}
		public void setBizId(String bizId) {
			this.bizId = bizId;
		}
		public String getBizType() {
			return this.bizType;
		}
		public void setBizType(String bizType) {
			this.bizType = bizType;
		}
		public String getBusinessParams() {
			return this.businessParams;
		}
		public void setBusinessParams(String businessParams) {
			this.businessParams = businessParams;
		}
		public void setBusinessParamsString(String businessParams) {
			this.businessParams = businessParams;
		}
		
		public String getPosition() {
			return this.position;
		}
		public void setPosition(String position) {
			this.position = position;
		}
		public String getSubBizType() {
			return this.subBizType;
		}
		public void setSubBizType(String subBizType) {
			this.subBizType = subBizType;
		}

}


}