package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractIsvadminBindResponse;

/**
 * TOP API: alibaba.interact.isvadmin.bind request
 * 
 * @author top auto create
 * @since 1.0, 2015.03.04
 */
public class AlibabaInteractIsvadminBindRequest extends BaseTaobaoRequest<AlibabaInteractIsvadminBindResponse> {
	
	

	/** 
	* 互动结束时间
	 */
	private Date endTime;

	/** 
	* 互动实例名称
	 */
	private String instanceName;

	/** 
	* 描述信息
	 */
	private String interactDescription;

	/** 
	* 奖池ID
	 */
	private String lotteryCode;

	/** 
	* 互动开始时间
	 */
	private Date startTime;

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setInstanceName(String instanceName) {
		this.instanceName = instanceName;
	}

	public String getInstanceName() {
		return this.instanceName;
	}

	public void setInteractDescription(String interactDescription) {
		this.interactDescription = interactDescription;
	}

	public String getInteractDescription() {
		return this.interactDescription;
	}

	public void setLotteryCode(String lotteryCode) {
		this.lotteryCode = lotteryCode;
	}

	public String getLotteryCode() {
		return this.lotteryCode;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "alibaba.interact.isvadmin.bind";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("end_time", this.endTime);
		txtParams.put("instance_name", this.instanceName);
		txtParams.put("interact_description", this.interactDescription);
		txtParams.put("lottery_code", this.lotteryCode);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractIsvadminBindResponse> getResponseClass() {
		return AlibabaInteractIsvadminBindResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(instanceName, "instanceName");
		RequestCheckUtils.checkNotEmpty(interactDescription, "interactDescription");
		RequestCheckUtils.checkNotEmpty(lotteryCode, "lotteryCode");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
	}
	

}