package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractIsvadminGetpondbyinteractResponse;

/**
 * TOP API: alibaba.interact.isvadmin.getpondbyinteract request
 * 
 * @author top auto create
 * @since 1.0, 2015.02.12
 */
public class AlibabaInteractIsvadminGetpondbyinteractRequest extends BaseTaobaoRequest<AlibabaInteractIsvadminGetpondbyinteractResponse> {
	
	

	/** 
	* 互动实例ID
	 */
	private String interactId;

	public void setInteractId(String interactId) {
		this.interactId = interactId;
	}

	public String getInteractId() {
		return this.interactId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.isvadmin.getpondbyinteract";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("interact_id", this.interactId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractIsvadminGetpondbyinteractResponse> getResponseClass() {
		return AlibabaInteractIsvadminGetpondbyinteractResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(interactId, "interactId");
	}
	

}