package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractIsvdataQueryscoreResponse;

/**
 * TOP API: alibaba.interact.isvdata.queryscore request
 * 
 * @author top auto create
 * @since 1.0, 2015.02.12
 */
public class AlibabaInteractIsvdataQueryscoreRequest extends BaseTaobaoRequest<AlibabaInteractIsvdataQueryscoreResponse> {
	
	

	/** 
	* 互动实例ID ISV通过绑定互动奖池并且生成互动实例接口 获取该ID
	 */
	private String interactId;

	public void setInteractId(String interactId) {
		this.interactId = interactId;
	}

	public String getInteractId() {
		return this.interactId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.isvdata.queryscore";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("interact_id", this.interactId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractIsvdataQueryscoreResponse> getResponseClass() {
		return AlibabaInteractIsvdataQueryscoreResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(interactId, "interactId");
	}
	

}