package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractIsvdataSavescoreResponse;

/**
 * TOP API: alibaba.interact.isvdata.savescore request
 * 
 * @author top auto create
 * @since 1.0, 2015.02.12
 */
public class AlibabaInteractIsvdataSavescoreRequest extends BaseTaobaoRequest<AlibabaInteractIsvdataSavescoreResponse> {
	
	

	/** 
	* 互动实例ID
	 */
	private String interactId;

	/** 
	* 用户分数
	 */
	private Long score;

	public void setInteractId(String interactId) {
		this.interactId = interactId;
	}

	public String getInteractId() {
		return this.interactId;
	}

	public void setScore(Long score) {
		this.score = score;
	}

	public Long getScore() {
		return this.score;
	}

	public String getApiMethodName() {
		return "alibaba.interact.isvdata.savescore";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("interact_id", this.interactId);
		txtParams.put("score", this.score);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractIsvdataSavescoreResponse> getResponseClass() {
		return AlibabaInteractIsvdataSavescoreResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(interactId, "interactId");
		RequestCheckUtils.checkNotEmpty(score, "score");
	}
	

}