package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractIsvlotteryIdrawResponse;

/**
 * TOP API: alibaba.interact.isvlottery.idraw request
 * 
 * @author top auto create
 * @since 1.0, 2016.09.20
 */
public class AlibabaInteractIsvlotteryIdrawRequest extends BaseTaobaoRequest<AlibabaInteractIsvlotteryIdrawResponse> {
	
	

	/** 
	* 抽奖ID列表 用逗号隔开
	 */
	private String awardIds;

	/** 
	* 互动实例ID
	 */
	private String interactId;

	/** 
	* 埋点参数
	 */
	private String ua;

	public void setAwardIds(String awardIds) {
		this.awardIds = awardIds;
	}

	public String getAwardIds() {
		return this.awardIds;
	}

	public void setInteractId(String interactId) {
		this.interactId = interactId;
	}

	public String getInteractId() {
		return this.interactId;
	}

	public void setUa(String ua) {
		this.ua = ua;
	}

	public String getUa() {
		return this.ua;
	}

	public String getApiMethodName() {
		return "alibaba.interact.isvlottery.idraw";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("award_ids", this.awardIds);
		txtParams.put("interact_id", this.interactId);
		txtParams.put("ua", this.ua);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractIsvlotteryIdrawResponse> getResponseClass() {
		return AlibabaInteractIsvlotteryIdrawResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(interactId, "interactId");
		RequestCheckUtils.checkNotEmpty(ua, "ua");
	}
	

}