package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaInteractLotteryactivityRegisterResponse;

/**
 * TOP API: alibaba.interact.lotteryactivity.register request
 * 
 * @author top auto create
 * @since 1.0, 2016.01.04
 */
public class AlibabaInteractLotteryactivityRegisterRequest extends BaseTaobaoRequest<AlibabaInteractLotteryactivityRegisterResponse> {
	
	

	/** 
	* 入参
	 */
	private String paramTopUpdateActivityLotteryInfoParam;

	public void setParamTopUpdateActivityLotteryInfoParam(String paramTopUpdateActivityLotteryInfoParam) {
		this.paramTopUpdateActivityLotteryInfoParam = paramTopUpdateActivityLotteryInfoParam;
	}

	public void setParamTopUpdateActivityLotteryInfoParam(TopUpdateActivityLotteryInfoParam paramTopUpdateActivityLotteryInfoParam) {
		this.paramTopUpdateActivityLotteryInfoParam = new JSONWriter(false,true).write(paramTopUpdateActivityLotteryInfoParam);
	}

	public String getParamTopUpdateActivityLotteryInfoParam() {
		return this.paramTopUpdateActivityLotteryInfoParam;
	}

	public String getApiMethodName() {
		return "alibaba.interact.lotteryactivity.register";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_top_update_activity_lottery_info_param", this.paramTopUpdateActivityLotteryInfoParam);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractLotteryactivityRegisterResponse> getResponseClass() {
		return AlibabaInteractLotteryactivityRegisterResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 入参
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopUpdateActivityLotteryInfoParam extends TaobaoObject {

	private static final long serialVersionUID = 1883351926962984715L;

	/**
		 * 商家通过isv创建的活动id
		 */
		@ApiField("activity_biz_id")
		private String activityBizId;
		/**
		 * isv的appkey
		 */
		@ApiField("app_key")
		private String appKey;
		/**
		 * 可随意传，目前没有用到，扩展字段
		 */
		@ApiField("banner_url")
		private String bannerUrl;
		/**
		 * 商家创建的红包总额
		 */
		@ApiField("benefit_amount")
		private String benefitAmount;
		/**
		 * 可随意传，目前没有用到，扩展字段
		 */
		@ApiField("benefit_attribute")
		private String benefitAttribute;
		/**
		 * 商家创建的红包面额
		 */
		@ApiField("benefit_denomination")
		private Long benefitDenomination;
		/**
		 * 商家选择使用的红包权益id
		 */
		@ApiField("benefit_id")
		private Long benefitId;
		/**
		 * 目前填1，代表支付宝红包
		 */
		@ApiField("benefit_type")
		private String benefitType;
		/**
		 * 目前必须填4，代表互动城
		 */
		@ApiField("biz_type")
		private String bizType;
		/**
		 * 商家创建的isv活动的结束时间
		 */
		@ApiField("end_time")
		private Date endTime;
		/**
		 * 抽奖活动开始时间，long型
		 */
		@ApiField("lottery_activity_end_date")
		private Long lotteryActivityEndDate;
		/**
		 * 抽奖活动结束时间
		 */
		@ApiField("lottery_activity_start_date")
		private Long lotteryActivityStartDate;
		/**
		 * 抽奖活动名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 奖品扩展字段
		 */
		@ApiField("prize_ext_attribute")
		private String prizeExtAttribute;
		/**
		 * 1元红包
		 */
		@ApiField("prize_name")
		private String prizeName;
		/**
		 * 奖品扩展字段
		 */
		@ApiField("prize_param_attribute")
		private String prizeParamAttribute;
		/**
		 * 奖品总数
		 */
		@ApiField("prize_quantity")
		private String prizeQuantity;
		/**
		 * 奖品总数
		 */
		@ApiField("prize_remain_quantity")
		private String prizeRemainQuantity;
		/**
		 * 必须填1，代表红包
		 */
		@ApiField("prize_type")
		private String prizeType;
		/**
		 * 0～1之间，代表奖池的概率
		 */
		@ApiField("probability")
		private String probability;
		/**
		 * 商家创建的isv活动的开始时间
		 */
		@ApiField("start_time")
		private Date startTime;
		/**
		 * 用户活动期间总共中奖次数限制
		 */
		@ApiField("win_permission_activity_count")
		private Long winPermissionActivityCount;
		/**
		 * 用户每天总共中奖次数限制
		 */
		@ApiField("win_permission_day_count")
		private Long winPermissionDayCount;
	

	public String getActivityBizId() {
			return this.activityBizId;
		}
		public void setActivityBizId(String activityBizId) {
			this.activityBizId = activityBizId;
		}
		public String getAppKey() {
			return this.appKey;
		}
		public void setAppKey(String appKey) {
			this.appKey = appKey;
		}
		public String getBannerUrl() {
			return this.bannerUrl;
		}
		public void setBannerUrl(String bannerUrl) {
			this.bannerUrl = bannerUrl;
		}
		public String getBenefitAmount() {
			return this.benefitAmount;
		}
		public void setBenefitAmount(String benefitAmount) {
			this.benefitAmount = benefitAmount;
		}
		public String getBenefitAttribute() {
			return this.benefitAttribute;
		}
		public void setBenefitAttribute(String benefitAttribute) {
			this.benefitAttribute = benefitAttribute;
		}
		public Long getBenefitDenomination() {
			return this.benefitDenomination;
		}
		public void setBenefitDenomination(Long benefitDenomination) {
			this.benefitDenomination = benefitDenomination;
		}
		public Long getBenefitId() {
			return this.benefitId;
		}
		public void setBenefitId(Long benefitId) {
			this.benefitId = benefitId;
		}
		public String getBenefitType() {
			return this.benefitType;
		}
		public void setBenefitType(String benefitType) {
			this.benefitType = benefitType;
		}
		public String getBizType() {
			return this.bizType;
		}
		public void setBizType(String bizType) {
			this.bizType = bizType;
		}
		public Date getEndTime() {
			return this.endTime;
		}
		public void setEndTime(Date endTime) {
			this.endTime = endTime;
		}
		public Long getLotteryActivityEndDate() {
			return this.lotteryActivityEndDate;
		}
		public void setLotteryActivityEndDate(Long lotteryActivityEndDate) {
			this.lotteryActivityEndDate = lotteryActivityEndDate;
		}
		public Long getLotteryActivityStartDate() {
			return this.lotteryActivityStartDate;
		}
		public void setLotteryActivityStartDate(Long lotteryActivityStartDate) {
			this.lotteryActivityStartDate = lotteryActivityStartDate;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getPrizeExtAttribute() {
			return this.prizeExtAttribute;
		}
		public void setPrizeExtAttribute(String prizeExtAttribute) {
			this.prizeExtAttribute = prizeExtAttribute;
		}
		public String getPrizeName() {
			return this.prizeName;
		}
		public void setPrizeName(String prizeName) {
			this.prizeName = prizeName;
		}
		public String getPrizeParamAttribute() {
			return this.prizeParamAttribute;
		}
		public void setPrizeParamAttribute(String prizeParamAttribute) {
			this.prizeParamAttribute = prizeParamAttribute;
		}
		public String getPrizeQuantity() {
			return this.prizeQuantity;
		}
		public void setPrizeQuantity(String prizeQuantity) {
			this.prizeQuantity = prizeQuantity;
		}
		public String getPrizeRemainQuantity() {
			return this.prizeRemainQuantity;
		}
		public void setPrizeRemainQuantity(String prizeRemainQuantity) {
			this.prizeRemainQuantity = prizeRemainQuantity;
		}
		public String getPrizeType() {
			return this.prizeType;
		}
		public void setPrizeType(String prizeType) {
			this.prizeType = prizeType;
		}
		public String getProbability() {
			return this.probability;
		}
		public void setProbability(String probability) {
			this.probability = probability;
		}
		public Date getStartTime() {
			return this.startTime;
		}
		public void setStartTime(Date startTime) {
			this.startTime = startTime;
		}
		public Long getWinPermissionActivityCount() {
			return this.winPermissionActivityCount;
		}
		public void setWinPermissionActivityCount(Long winPermissionActivityCount) {
			this.winPermissionActivityCount = winPermissionActivityCount;
		}
		public Long getWinPermissionDayCount() {
			return this.winPermissionDayCount;
		}
		public void setWinPermissionDayCount(Long winPermissionDayCount) {
			this.winPermissionDayCount = winPermissionDayCount;
		}

}


}