package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaInteractLotterydrawDodrawResponse;

/**
 * TOP API: alibaba.interact.lotterydraw.dodraw request
 * 
 * @author top auto create
 * @since 1.0, 2017.04.06
 */
public class AlibabaInteractLotterydrawDodrawRequest extends BaseTaobaoRequest<AlibabaInteractLotterydrawDodrawResponse> {
	
	

	/** 
	* 抽奖请求对象
	 */
	private String lotteryDrawQuery;

	public void setLotteryDrawQuery(String lotteryDrawQuery) {
		this.lotteryDrawQuery = lotteryDrawQuery;
	}

	public void setLotteryDrawQuery(LotteryDrawQueryDto lotteryDrawQuery) {
		this.lotteryDrawQuery = new JSONWriter(false,true).write(lotteryDrawQuery);
	}

	public String getLotteryDrawQuery() {
		return this.lotteryDrawQuery;
	}

	public String getApiMethodName() {
		return "alibaba.interact.lotterydraw.dodraw";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("lottery_draw_query", this.lotteryDrawQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractLotterydrawDodrawResponse> getResponseClass() {
		return AlibabaInteractLotterydrawDodrawResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 抽奖请求对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LotteryDrawQueryDto extends TaobaoObject {

	private static final long serialVersionUID = 7523647699238618519L;

	/**
		 * 抽奖CODE
		 */
		@ApiField("raffle_code")
		private String raffleCode;
		/**
		 * 前台appKey
		 */
		@ApiField("raffle_identity")
		private String raffleIdentity;
		/**
		 * 关联ID
		 */
		@ApiField("relation_id")
		private String relationId;
		/**
		 * 方案ID
		 */
		@ApiField("schema_id")
		private Long schemaId;
		/**
		 * 抽奖参数
		 */
		@ApiField("wua")
		private String wua;
	

	public String getRaffleCode() {
			return this.raffleCode;
		}
		public void setRaffleCode(String raffleCode) {
			this.raffleCode = raffleCode;
		}
		public String getRaffleIdentity() {
			return this.raffleIdentity;
		}
		public void setRaffleIdentity(String raffleIdentity) {
			this.raffleIdentity = raffleIdentity;
		}
		public String getRelationId() {
			return this.relationId;
		}
		public void setRelationId(String relationId) {
			this.relationId = relationId;
		}
		public Long getSchemaId() {
			return this.schemaId;
		}
		public void setSchemaId(Long schemaId) {
			this.schemaId = schemaId;
		}
		public String getWua() {
			return this.wua;
		}
		public void setWua(String wua) {
			this.wua = wua;
		}

}


}