package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractTidaCartResultResponse;

/**
 * TOP API: alibaba.interact.tida.cart.result request
 * 
 * @author top auto create
 * @since 1.0, 2015.09.25
 */
public class AlibabaInteractTidaCartResultRequest extends BaseTaobaoRequest<AlibabaInteractTidaCartResultResponse> {
	
	

	/** 
	* ISV自定义，推荐字符串，慎用json
	 */
	private String isvExt;

	/** 
	* tida加购物车接口的商品id
	 */
	private String itemId;

	/** 
	* 买家混淆nick
	 */
	private String mixBuyerNick;

	/** 
	* 卖家昵称
	 */
	private String sellerNick;

	/** 
	* tida加购物车接口的skuid
	 */
	private String skuId;

	/** 
	* 排查线索
	 */
	private String traceId;

	public void setIsvExt(String isvExt) {
		this.isvExt = isvExt;
	}

	public String getIsvExt() {
		return this.isvExt;
	}

	public void setItemId(String itemId) {
		this.itemId = itemId;
	}

	public String getItemId() {
		return this.itemId;
	}

	public void setMixBuyerNick(String mixBuyerNick) {
		this.mixBuyerNick = mixBuyerNick;
	}

	public String getMixBuyerNick() {
		return this.mixBuyerNick;
	}

	public void setSellerNick(String sellerNick) {
		this.sellerNick = sellerNick;
	}

	public String getSellerNick() {
		return this.sellerNick;
	}

	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public String getSkuId() {
		return this.skuId;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.tida.cart.result";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("isv_ext", this.isvExt);
		txtParams.put("item_id", this.itemId);
		txtParams.put("mix_buyer_nick", this.mixBuyerNick);
		txtParams.put("seller_nick", this.sellerNick);
		txtParams.put("sku_id", this.skuId);
		txtParams.put("trace_id", this.traceId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractTidaCartResultResponse> getResponseClass() {
		return AlibabaInteractTidaCartResultResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}