package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractTidaGetMaterialidResponse;

/**
 * TOP API: alibaba.interact.tida.get.materialid request
 * 
 * @author top auto create
 * @since 1.0, 2015.06.25
 */
public class AlibabaInteractTidaGetMaterialidRequest extends BaseTaobaoRequest<AlibabaInteractTidaGetMaterialidResponse> {
	
	

	/** 
	* itemId和skuId二元组的列表
	 */
	private String itemidSkuids;

	public void setItemidSkuids(String itemidSkuids) {
		this.itemidSkuids = itemidSkuids;
	}

	public String getItemidSkuids() {
		return this.itemidSkuids;
	}

	public String getApiMethodName() {
		return "alibaba.interact.tida.get.materialid";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("itemid_skuids", this.itemidSkuids);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractTidaGetMaterialidResponse> getResponseClass() {
		return AlibabaInteractTidaGetMaterialidResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(itemidSkuids, "itemidSkuids");
	}
	

}