package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaInteractTidaOnecodeIssueResponse;

/**
 * TOP API: alibaba.interact.tida.onecode.issue request
 * 
 * @author top auto create
 * @since 1.0, 2016.05.16
 */
public class AlibabaInteractTidaOnecodeIssueRequest extends BaseTaobaoRequest<AlibabaInteractTidaOnecodeIssueResponse> {
	
	

	/** 
	* 支持onecode的接口，令牌对应接口
	 */
	private String api;

	/** 
	* 透传参数
	 */
	private String bizExtString;

	/** 
	* 手淘登陆用户混淆nick
	 */
	private String mixUserNick;

	/** 
	* 安全过滤结果，是否安全。
	 */
	private String safety;

	/** 
	* 支持onecode的接口单次调用令牌
	 */
	private String ticket;

	/** 
	* 唯一。单次请求调试信息，可作为请求记录ID
	 */
	private String traceId;

	public void setApi(String api) {
		this.api = api;
	}

	public String getApi() {
		return this.api;
	}

	public void setBizExtString(String bizExtString) {
		this.bizExtString = bizExtString;
	}

	public String getBizExtString() {
		return this.bizExtString;
	}

	public void setMixUserNick(String mixUserNick) {
		this.mixUserNick = mixUserNick;
	}

	public String getMixUserNick() {
		return this.mixUserNick;
	}

	public void setSafety(String safety) {
		this.safety = safety;
	}

	public String getSafety() {
		return this.safety;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	public String getTicket() {
		return this.ticket;
	}

	public void setTraceId(String traceId) {
		this.traceId = traceId;
	}

	public String getTraceId() {
		return this.traceId;
	}

	public String getApiMethodName() {
		return "alibaba.interact.tida.onecode.issue";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("api", this.api);
		txtParams.put("biz_ext_string", this.bizExtString);
		txtParams.put("mix_user_nick", this.mixUserNick);
		txtParams.put("safety", this.safety);
		txtParams.put("ticket", this.ticket);
		txtParams.put("trace_id", this.traceId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaInteractTidaOnecodeIssueResponse> getResponseClass() {
		return AlibabaInteractTidaOnecodeIssueResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(api, "api");
		RequestCheckUtils.checkNotEmpty(mixUserNick, "mixUserNick");
		RequestCheckUtils.checkNotEmpty(ticket, "ticket");
		RequestCheckUtils.checkNotEmpty(traceId, "traceId");
	}
	

}