package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaMarketingLotteryDrawDodrawResponse;

/**
 * TOP API: alibaba.marketing.lottery.draw.dodraw request
 * 
 * @author top auto create
 * @since 1.0, 2017.05.11
 */
public class AlibabaMarketingLotteryDrawDodrawRequest extends BaseTaobaoRequest<AlibabaMarketingLotteryDrawDodrawResponse> {
	
	

	/** 
	* 抽奖请求对象
	 */
	private String lotteryDrawQuery;

	public void setLotteryDrawQuery(String lotteryDrawQuery) {
		this.lotteryDrawQuery = lotteryDrawQuery;
	}

	public void setLotteryDrawQuery(LotteryDrawQueryDto lotteryDrawQuery) {
		this.lotteryDrawQuery = new JSONWriter(false,true).write(lotteryDrawQuery);
	}

	public String getLotteryDrawQuery() {
		return this.lotteryDrawQuery;
	}

	public String getApiMethodName() {
		return "alibaba.marketing.lottery.draw.dodraw";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("lottery_draw_query", this.lotteryDrawQuery);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaMarketingLotteryDrawDodrawResponse> getResponseClass() {
		return AlibabaMarketingLotteryDrawDodrawResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 抽奖请求对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class LotteryDrawQueryDto extends TaobaoObject {

	private static final long serialVersionUID = 3638955485931844713L;

	/**
		 * 买家混淆Nick
		 */
		@ApiField("buyer_mix_nick")
		private String buyerMixNick;
		/**
		 * 抽奖code
		 */
		@ApiField("raffle_code")
		private String raffleCode;
		/**
		 * 关联id
		 */
		@ApiField("relation_id")
		private String relationId;
		/**
		 * 用户ip
		 */
		@ApiField("remote_ip")
		private String remoteIp;
		/**
		 * 方案id
		 */
		@ApiField("schema_id")
		private Long schemaId;
		/**
		 * 抽奖参数
		 */
		@ApiField("ua")
		private String ua;
		/**
		 * 抽奖参数
		 */
		@ApiField("umid_token")
		private String umidToken;
		/**
		 * 用户终端信息
		 */
		@ApiField("user_agent")
		private String userAgent;
	

	public String getBuyerMixNick() {
			return this.buyerMixNick;
		}
		public void setBuyerMixNick(String buyerMixNick) {
			this.buyerMixNick = buyerMixNick;
		}
		public String getRaffleCode() {
			return this.raffleCode;
		}
		public void setRaffleCode(String raffleCode) {
			this.raffleCode = raffleCode;
		}
		public String getRelationId() {
			return this.relationId;
		}
		public void setRelationId(String relationId) {
			this.relationId = relationId;
		}
		public String getRemoteIp() {
			return this.remoteIp;
		}
		public void setRemoteIp(String remoteIp) {
			this.remoteIp = remoteIp;
		}
		public Long getSchemaId() {
			return this.schemaId;
		}
		public void setSchemaId(Long schemaId) {
			this.schemaId = schemaId;
		}
		public String getUa() {
			return this.ua;
		}
		public void setUa(String ua) {
			this.ua = ua;
		}
		public String getUmidToken() {
			return this.umidToken;
		}
		public void setUmidToken(String umidToken) {
			this.umidToken = umidToken;
		}
		public String getUserAgent() {
			return this.userAgent;
		}
		public void setUserAgent(String userAgent) {
			this.userAgent = userAgent;
		}

}


}