package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinActivitiesQueryResponse;

/**
 * TOP API: taobao.coin.activities.query request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinActivitiesQueryRequest extends BaseTaobaoRequest<CoinActivitiesQueryResponse> {
	
	

	/** 
	* 活动创建时间：起始点
	 */
	private Date createTimeFrom;

	/** 
	* 活动创建时间：超始点
	 */
	private Date createTimeTo;

	/** 
	* 活动结束时间：起始点
	 */
	private Date endTimeFrom;

	/** 
	* 活动结束时间：截止点
	 */
	private Date endTimeTo;

	/** 
	* 活动ID列表
	 */
	private String outActivityIds;

	/** 
	* 当前页，从1开始
	 */
	private Long page;

	/** 
	* 单次返回记录数
	 */
	private Long pageSize;

	/** 
	* 活动开始时间：起始点
	 */
	private Date startTimeFrom;

	/** 
	* 活动开始时间：截止点
	 */
	private Date startTimeTo;

	/** 
	* 状态，0-有效状态，-1-创建失败，-2-卖家中止, -3-系统中止, -4-到期终止
	 */
	private String status;

	/** 
	* 淘宝活动ID
	 */
	private String tbActivityIds;

	public void setCreateTimeFrom(Date createTimeFrom) {
		this.createTimeFrom = createTimeFrom;
	}

	public Date getCreateTimeFrom() {
		return this.createTimeFrom;
	}

	public void setCreateTimeTo(Date createTimeTo) {
		this.createTimeTo = createTimeTo;
	}

	public Date getCreateTimeTo() {
		return this.createTimeTo;
	}

	public void setEndTimeFrom(Date endTimeFrom) {
		this.endTimeFrom = endTimeFrom;
	}

	public Date getEndTimeFrom() {
		return this.endTimeFrom;
	}

	public void setEndTimeTo(Date endTimeTo) {
		this.endTimeTo = endTimeTo;
	}

	public Date getEndTimeTo() {
		return this.endTimeTo;
	}

	public void setOutActivityIds(String outActivityIds) {
		this.outActivityIds = outActivityIds;
	}

	public String getOutActivityIds() {
		return this.outActivityIds;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setStartTimeFrom(Date startTimeFrom) {
		this.startTimeFrom = startTimeFrom;
	}

	public Date getStartTimeFrom() {
		return this.startTimeFrom;
	}

	public void setStartTimeTo(Date startTimeTo) {
		this.startTimeTo = startTimeTo;
	}

	public Date getStartTimeTo() {
		return this.startTimeTo;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatus() {
		return this.status;
	}

	public void setTbActivityIds(String tbActivityIds) {
		this.tbActivityIds = tbActivityIds;
	}

	public String getTbActivityIds() {
		return this.tbActivityIds;
	}

	public String getApiMethodName() {
		return "taobao.coin.activities.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("create_time_from", this.createTimeFrom);
		txtParams.put("create_time_to", this.createTimeTo);
		txtParams.put("end_time_from", this.endTimeFrom);
		txtParams.put("end_time_to", this.endTimeTo);
		txtParams.put("out_activity_ids", this.outActivityIds);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("start_time_from", this.startTimeFrom);
		txtParams.put("start_time_to", this.startTimeTo);
		txtParams.put("status", this.status);
		txtParams.put("tb_activity_ids", this.tbActivityIds);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinActivitiesQueryResponse> getResponseClass() {
		return CoinActivitiesQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(outActivityIds, 20, "outActivityIds");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkMaxListSize(status, 20, "status");
		RequestCheckUtils.checkMaxListSize(tbActivityIds, 20, "tbActivityIds");
	}
	

}