package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinActivityBudgetReduceResponse;

/**
 * TOP API: taobao.coin.activity.budget.reduce request
 * 
 * @author top auto create
 * @since 1.0, 2014.12.17
 */
public class CoinActivityBudgetReduceRequest extends BaseTaobaoRequest<CoinActivityBudgetReduceResponse> {
	
	

	/** 
	* 变更的预算金币数
	 */
	private Long amount;

	/** 
	* 淘金币活动ID
	 */
	private Long tbActivityId;

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getAmount() {
		return this.amount;
	}

	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}

	public String getApiMethodName() {
		return "taobao.coin.activity.budget.reduce";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("amount", this.amount);
		txtParams.put("tb_activity_id", this.tbActivityId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinActivityBudgetReduceResponse> getResponseClass() {
		return CoinActivityBudgetReduceResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(amount, "amount");
		RequestCheckUtils.checkNotEmpty(tbActivityId, "tbActivityId");
	}
	

}