package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinActivityCreateResponse;

/**
 * TOP API: taobao.coin.activity.create request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinActivityCreateRequest extends BaseTaobaoRequest<CoinActivityCreateResponse> {
	
	

	/** 
	* 直接内嵌在店铺淘金币页面的活动参与入口，需要遵循相应的前端交互规范
	 */
	private String activityInlineUrl;

	/** 
	* 活动标题
	 */
	private String activityTitle;

	/** 
	* 活动参与入口URL(需要通过淘宝oauth2.0认证)
	 */
	private String activityUrl;

	/** 
	* 用于活动消耗的淘金币预算额，1000起步
	 */
	private Long budgetAmount;

	/** 
	* 活动结束时间
	 */
	private Date endTime;

	/** 
	* 外部扩展参数
	 */
	private String feature;

	/** 
	* 外部活动ID，即App中对应活动ID
	 */
	private Long outActivityId;

	/** 
	* 活动开始时间
	 */
	private Date startTime;

	public void setActivityInlineUrl(String activityInlineUrl) {
		this.activityInlineUrl = activityInlineUrl;
	}

	public String getActivityInlineUrl() {
		return this.activityInlineUrl;
	}

	public void setActivityTitle(String activityTitle) {
		this.activityTitle = activityTitle;
	}

	public String getActivityTitle() {
		return this.activityTitle;
	}

	public void setActivityUrl(String activityUrl) {
		this.activityUrl = activityUrl;
	}

	public String getActivityUrl() {
		return this.activityUrl;
	}

	public void setBudgetAmount(Long budgetAmount) {
		this.budgetAmount = budgetAmount;
	}

	public Long getBudgetAmount() {
		return this.budgetAmount;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setFeature(String feature) {
		this.feature = feature;
	}
	public void setFeatureString(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setOutActivityId(Long outActivityId) {
		this.outActivityId = outActivityId;
	}

	public Long getOutActivityId() {
		return this.outActivityId;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public String getApiMethodName() {
		return "taobao.coin.activity.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_inline_url", this.activityInlineUrl);
		txtParams.put("activity_title", this.activityTitle);
		txtParams.put("activity_url", this.activityUrl);
		txtParams.put("budget_amount", this.budgetAmount);
		txtParams.put("end_time", this.endTime);
		txtParams.put("feature", this.feature);
		txtParams.put("out_activity_id", this.outActivityId);
		txtParams.put("start_time", this.startTime);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinActivityCreateResponse> getResponseClass() {
		return CoinActivityCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(activityTitle, "activityTitle");
		RequestCheckUtils.checkNotEmpty(budgetAmount, "budgetAmount");
		RequestCheckUtils.checkNotEmpty(endTime, "endTime");
		RequestCheckUtils.checkNotEmpty(outActivityId, "outActivityId");
		RequestCheckUtils.checkNotEmpty(startTime, "startTime");
	}
	

}