package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinActivityStopResponse;

/**
 * TOP API: taobao.coin.activity.stop request
 * 
 * @author top auto create
 * @since 1.0, 2014.12.17
 */
public class CoinActivityStopRequest extends BaseTaobaoRequest<CoinActivityStopResponse> {
	
	

	/** 
	* 淘金币活动ID
	 */
	private Long tbActivityId;

	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}

	public String getApiMethodName() {
		return "taobao.coin.activity.stop";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tb_activity_id", this.tbActivityId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinActivityStopResponse> getResponseClass() {
		return CoinActivityStopResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tbActivityId, "tbActivityId");
	}
	

}