package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinActivityUpdateResponse;

/**
 * TOP API: taobao.coin.activity.update request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinActivityUpdateRequest extends BaseTaobaoRequest<CoinActivityUpdateResponse> {
	
	

	/** 
	* 活动标题
	 */
	private String activityTitle;

	/** 
	* 活动结束时间
	 */
	private Date endTime;

	/** 
	* 外部扩展属性
	 */
	private String feature;

	/** 
	* 活动开始时间
	 */
	private Date startTime;

	/** 
	* 淘金币平台活动ID
	 */
	private Long tbActivityId;

	public void setActivityTitle(String activityTitle) {
		this.activityTitle = activityTitle;
	}

	public String getActivityTitle() {
		return this.activityTitle;
	}

	public void setEndTime(Date endTime) {
		this.endTime = endTime;
	}

	public Date getEndTime() {
		return this.endTime;
	}

	public void setFeature(String feature) {
		this.feature = feature;
	}
	public void setFeatureString(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setStartTime(Date startTime) {
		this.startTime = startTime;
	}

	public Date getStartTime() {
		return this.startTime;
	}

	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}

	public String getApiMethodName() {
		return "taobao.coin.activity.update";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("activity_title", this.activityTitle);
		txtParams.put("end_time", this.endTime);
		txtParams.put("feature", this.feature);
		txtParams.put("start_time", this.startTime);
		txtParams.put("tb_activity_id", this.tbActivityId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinActivityUpdateResponse> getResponseClass() {
		return CoinActivityUpdateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tbActivityId, "tbActivityId");
	}
	

}