package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinBuyerConsumeResponse;

/**
 * TOP API: taobao.coin.buyer.consume request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinBuyerConsumeRequest extends BaseTaobaoRequest<CoinBuyerConsumeResponse> {
	
	

	/** 
	* 本次消耗的金币数
	 */
	private Long amount;

	/** 
	* 买家nick，使用top混淆nick
	 */
	private String buyerNick;

	/** 
	* 备注
	 */
	private String comments;

	/** 
	* 应用扩展属性
	 */
	private String feature;

	/** 
	* 与本次金币操作关联的外键ID（app范围内唯一），如提供，作为本接口幂等校验的依据。
	 */
	private Long outId;

	/** 
	* 外键父ID
	 */
	private Long outParentId;

	/** 
	* 令牌
	 */
	private String token;

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getAmount() {
		return this.amount;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getComments() {
		return this.comments;
	}

	public void setFeature(String feature) {
		this.feature = feature;
	}
	public void setFeatureString(String feature) {
		this.feature = feature;
	}

	public String getFeature() {
		return this.feature;
	}

	public void setOutId(Long outId) {
		this.outId = outId;
	}

	public Long getOutId() {
		return this.outId;
	}

	public void setOutParentId(Long outParentId) {
		this.outParentId = outParentId;
	}

	public Long getOutParentId() {
		return this.outParentId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.coin.buyer.consume";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("amount", this.amount);
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("comments", this.comments);
		txtParams.put("feature", this.feature);
		txtParams.put("out_id", this.outId);
		txtParams.put("out_parent_id", this.outParentId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinBuyerConsumeResponse> getResponseClass() {
		return CoinBuyerConsumeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(amount, "amount");
		RequestCheckUtils.checkNotEmpty(buyerNick, "buyerNick");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}