package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinBuyerDetailsQueryResponse;

/**
 * TOP API: taobao.coin.buyer.details.query request
 * 
 * @author top auto create
 * @since 1.0, 2014.12.16
 */
public class CoinBuyerDetailsQueryRequest extends BaseTaobaoRequest<CoinBuyerDetailsQueryResponse> {
	
	

	/** 
	* 记录创建时间：开始点
	 */
	private Date createTimeFrom;

	/** 
	* 记录创建时间：截止点
	 */
	private Date createTimeTo;

	/** 
	* 查询外键
	 */
	private String outIds;

	/** 
	* 当前页
	 */
	private Long page;

	/** 
	* 单页大小
	 */
	private Long pageSize;

	/** 
	* 查询类型，0-全部，1-发放，2-消耗
	 */
	private Long type;

	public void setCreateTimeFrom(Date createTimeFrom) {
		this.createTimeFrom = createTimeFrom;
	}

	public Date getCreateTimeFrom() {
		return this.createTimeFrom;
	}

	public void setCreateTimeTo(Date createTimeTo) {
		this.createTimeTo = createTimeTo;
	}

	public Date getCreateTimeTo() {
		return this.createTimeTo;
	}

	public void setOutIds(String outIds) {
		this.outIds = outIds;
	}

	public String getOutIds() {
		return this.outIds;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setType(Long type) {
		this.type = type;
	}

	public Long getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.coin.buyer.details.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("create_time_from", this.createTimeFrom);
		txtParams.put("create_time_to", this.createTimeTo);
		txtParams.put("out_ids", this.outIds);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinBuyerDetailsQueryResponse> getResponseClass() {
		return CoinBuyerDetailsQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(outIds, 20, "outIds");
		RequestCheckUtils.checkNotEmpty(page, "page");
		RequestCheckUtils.checkNotEmpty(pageSize, "pageSize");
		RequestCheckUtils.checkNotEmpty(type, "type");
	}
	

}