package com.taobao.api.request;

import java.util.Date;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinSellerDetailsQueryResponse;

/**
 * TOP API: taobao.coin.seller.details.query request
 * 
 * @author top auto create
 * @since 1.0, 2014.12.17
 */
public class CoinSellerDetailsQueryRequest extends BaseTaobaoRequest<CoinSellerDetailsQueryResponse> {
	
	

	/** 
	* 明细创建时间：起始点
	 */
	private Date createTimeFrom;

	/** 
	* 明细创建时间：截止点
	 */
	private Date createTimeTo;

	/** 
	* 外键ID列表
	 */
	private String outIds;

	/** 
	* 当前页码，从1开始
	 */
	private Long page;

	/** 
	* 单页记录数
	 */
	private Long pageSize;

	/** 
	* 淘金币平台活动ID列表
	 */
	private String tbActivityIds;

	/** 
	* 明细类型，0-全部，1-赚取，2-消耗
	 */
	private Long type;

	public void setCreateTimeFrom(Date createTimeFrom) {
		this.createTimeFrom = createTimeFrom;
	}

	public Date getCreateTimeFrom() {
		return this.createTimeFrom;
	}

	public void setCreateTimeTo(Date createTimeTo) {
		this.createTimeTo = createTimeTo;
	}

	public Date getCreateTimeTo() {
		return this.createTimeTo;
	}

	public void setOutIds(String outIds) {
		this.outIds = outIds;
	}

	public String getOutIds() {
		return this.outIds;
	}

	public void setPage(Long page) {
		this.page = page;
	}

	public Long getPage() {
		return this.page;
	}

	public void setPageSize(Long pageSize) {
		this.pageSize = pageSize;
	}

	public Long getPageSize() {
		return this.pageSize;
	}

	public void setTbActivityIds(String tbActivityIds) {
		this.tbActivityIds = tbActivityIds;
	}

	public String getTbActivityIds() {
		return this.tbActivityIds;
	}

	public void setType(Long type) {
		this.type = type;
	}

	public Long getType() {
		return this.type;
	}

	public String getApiMethodName() {
		return "taobao.coin.seller.details.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("create_time_from", this.createTimeFrom);
		txtParams.put("create_time_to", this.createTimeTo);
		txtParams.put("out_ids", this.outIds);
		txtParams.put("page", this.page);
		txtParams.put("page_size", this.pageSize);
		txtParams.put("tb_activity_ids", this.tbActivityIds);
		txtParams.put("type", this.type);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinSellerDetailsQueryResponse> getResponseClass() {
		return CoinSellerDetailsQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(outIds, 20, "outIds");
		RequestCheckUtils.checkMaxListSize(tbActivityIds, 20, "tbActivityIds");
	}
	

}