package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinSellerGiveResponse;

/**
 * TOP API: taobao.coin.seller.give request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinSellerGiveRequest extends BaseTaobaoRequest<CoinSellerGiveResponse> {
	
	

	/** 
	* 本次发放金币数
	 */
	private Long amount;

	/** 
	* APP自行扩展字段，key-value对
	 */
	private String attributes;

	/** 
	* 用户nick，使用top混淆nick
	 */
	private String buyerNick;

	/** 
	* 本次流转备注
	 */
	private String comments;

	/** 
	* 与本次金币操作关联的外键ID（app范围内唯一），如提供，作为本接口幂等校验的依据。
	 */
	private Long outId;

	/** 
	* 淘金币平台活动ID
	 */
	private Long tbActivityId;

	/** 
	* 淘金币令牌
	 */
	private String token;

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getAmount() {
		return this.amount;
	}

	public void setAttributes(String attributes) {
		this.attributes = attributes;
	}
	public void setAttributesString(String attributes) {
		this.attributes = attributes;
	}

	public String getAttributes() {
		return this.attributes;
	}

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public String getComments() {
		return this.comments;
	}

	public void setOutId(Long outId) {
		this.outId = outId;
	}

	public Long getOutId() {
		return this.outId;
	}

	public void setTbActivityId(Long tbActivityId) {
		this.tbActivityId = tbActivityId;
	}

	public Long getTbActivityId() {
		return this.tbActivityId;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getToken() {
		return this.token;
	}

	public String getApiMethodName() {
		return "taobao.coin.seller.give";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("amount", this.amount);
		txtParams.put("attributes", this.attributes);
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("comments", this.comments);
		txtParams.put("out_id", this.outId);
		txtParams.put("tb_activity_id", this.tbActivityId);
		txtParams.put("token", this.token);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinSellerGiveResponse> getResponseClass() {
		return CoinSellerGiveResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(amount, "amount");
		RequestCheckUtils.checkNotEmpty(buyerNick, "buyerNick");
		RequestCheckUtils.checkNotEmpty(tbActivityId, "tbActivityId");
		RequestCheckUtils.checkNotEmpty(token, "token");
	}
	

}