package com.taobao.api.request;

import com.taobao.api.internal.util.json.JSONValidatingReader;
import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CoinTokenGetResponse;

/**
 * TOP API: taobao.coin.token.get request
 * 
 * @author top auto create
 * @since 1.0, 2015.01.15
 */
public class CoinTokenGetRequest extends BaseTaobaoRequest<CoinTokenGetResponse> {
	
	

	/** 
	* 买家nick, 使用top混淆nick
	 */
	private String buyerNick;

	/** 
	* 需要二次验证时，用户识别的验证码字符串
	 */
	private String checkCode;

	/** 
	* 原请求头部信息
	 */
	private String header;

	/** 
	* 客户端IP
	 */
	private String remoteIp;

	/** 
	* 原请求头部信息
	 */
	private String userAgent;

	/** 
	* 原请求头部信息
	 */
	private String xForwardedFor;

	public void setBuyerNick(String buyerNick) {
		this.buyerNick = buyerNick;
	}

	public String getBuyerNick() {
		return this.buyerNick;
	}

	public void setCheckCode(String checkCode) {
		this.checkCode = checkCode;
	}

	public String getCheckCode() {
		return this.checkCode;
	}

	public void setHeader(String header) {
		this.header = header;
	}
	public void setHeaderString(String header) {
		this.header = header;
	}

	public String getHeader() {
		return this.header;
	}

	public void setRemoteIp(String remoteIp) {
		this.remoteIp = remoteIp;
	}

	public String getRemoteIp() {
		return this.remoteIp;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	public String getUserAgent() {
		return this.userAgent;
	}

	public void setxForwardedFor(String xForwardedFor) {
		this.xForwardedFor = xForwardedFor;
	}

	public String getxForwardedFor() {
		return this.xForwardedFor;
	}

	public String getApiMethodName() {
		return "taobao.coin.token.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_nick", this.buyerNick);
		txtParams.put("check_code", this.checkCode);
		txtParams.put("header", this.header);
		txtParams.put("remote_ip", this.remoteIp);
		txtParams.put("user_agent", this.userAgent);
		txtParams.put("x_forwarded_for", this.xForwardedFor);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CoinTokenGetResponse> getResponseClass() {
		return CoinTokenGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerNick, "buyerNick");
	}
	

}