package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.CrmServiceChannelShortlinkCreateResponse;

/**
 * TOP API: taobao.crm.service.channel.shortlink.create request
 * 
 * @author top auto create
 * @since 1.0, 2015.07.02
 */
public class CrmServiceChannelShortlinkCreateRequest extends BaseTaobaoRequest<CrmServiceChannelShortlinkCreateResponse> {
	
	

	/** 
	* 淘短链类型：LT_ITEM（商品淘短链）,LT_SHOP（店铺首页淘短链）,LT_ACTIVITY（活动页淘短链）,LT_TRADE（订单详情页淘短链）。
	 */
	private String linkType;

	/** 
	* 类型为LT_ITEM时必须传入商品ID，类型为LT_SHOP时必须传入空值，类型为LT_ACTIVITY时传入活动页URL（URL必须是taobao.com,tmall.com,jaeapp.com这三个域名下的URL），类型为LT_TRADE时传入订单ID。
	 */
	private String shortLinkData;

	/** 
	* 淘短链名称（最多只能16个中文字符，类型为订单链接时传入订单ID）。
	 */
	private String shortLinkName;

	public void setLinkType(String linkType) {
		this.linkType = linkType;
	}

	public String getLinkType() {
		return this.linkType;
	}

	public void setShortLinkData(String shortLinkData) {
		this.shortLinkData = shortLinkData;
	}

	public String getShortLinkData() {
		return this.shortLinkData;
	}

	public void setShortLinkName(String shortLinkName) {
		this.shortLinkName = shortLinkName;
	}

	public String getShortLinkName() {
		return this.shortLinkName;
	}

	public String getApiMethodName() {
		return "taobao.crm.service.channel.shortlink.create";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("link_type", this.linkType);
		txtParams.put("short_link_data", this.shortLinkData);
		txtParams.put("short_link_name", this.shortLinkName);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<CrmServiceChannelShortlinkCreateResponse> getResponseClass() {
		return CrmServiceChannelShortlinkCreateResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(linkType, "linkType");
		RequestCheckUtils.checkNotEmpty(shortLinkName, "shortLinkName");
	}
	

}