package com.taobao.api.request;

import com.taobao.api.domain.OrderConfirmQueryDto;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FuwuPurchaseOrderConfirmResponse;

/**
 * TOP API: taobao.fuwu.purchase.order.confirm request
 * 
 * @author top auto create
 * @since 1.0, 2015.10.15
 */
public class FuwuPurchaseOrderConfirmRequest extends BaseTaobaoRequest<FuwuPurchaseOrderConfirmResponse> {
	
	

	/** 
	* 内购服务下单接口参数
	 */
	private String paramOrderConfirmQueryDTO;

	public void setParamOrderConfirmQueryDTO(String paramOrderConfirmQueryDTO) {
		this.paramOrderConfirmQueryDTO = paramOrderConfirmQueryDTO;
	}

	public void setParamOrderConfirmQueryDTO(OrderConfirmQueryDto paramOrderConfirmQueryDTO) {
		this.paramOrderConfirmQueryDTO = new JSONWriter(false,true).write(paramOrderConfirmQueryDTO);
	}

	public String getParamOrderConfirmQueryDTO() {
		return this.paramOrderConfirmQueryDTO;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.purchase.order.confirm";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_order_confirm_query_d_t_o", this.paramOrderConfirmQueryDTO);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuPurchaseOrderConfirmResponse> getResponseClass() {
		return FuwuPurchaseOrderConfirmResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}