package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FuwuSkuGetResponse;

/**
 * TOP API: taobao.fuwu.sku.get request
 * 
 * @author top auto create
 * @since 1.0, 2015.12.17
 */
public class FuwuSkuGetRequest extends BaseTaobaoRequest<FuwuSkuGetResponse> {
	
	

	/** 
	* 应用注册在开放平台的的Appkey
	 */
	private String appKey;

	/** 
	* 服务code
	 */
	private String articleCode;

	/** 
	* 用户的淘宝nick
	 */
	private String nick;

	public void setAppKey(String appKey) {
		this.appKey = appKey;
	}

	public String getAppKey() {
		return this.appKey;
	}

	public void setArticleCode(String articleCode) {
		this.articleCode = articleCode;
	}

	public String getArticleCode() {
		return this.articleCode;
	}

	public void setNick(String nick) {
		this.nick = nick;
	}

	public String getNick() {
		return this.nick;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.sku.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("appKey", this.appKey);
		txtParams.put("article_code", this.articleCode);
		txtParams.put("nick", this.nick);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuSkuGetResponse> getResponseClass() {
		return FuwuSkuGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(appKey, "appKey");
		RequestCheckUtils.checkNotEmpty(articleCode, "articleCode");
		RequestCheckUtils.checkNotEmpty(nick, "nick");
	}
	

}