package com.taobao.api.request;

import com.taobao.api.domain.BillRecordDto;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FuwuSpBillreordAddResponse;

/**
 * TOP API: taobao.fuwu.sp.billreord.add request
 * 
 * @author top auto create
 * @since 1.0, 2015.09.10
 */
public class FuwuSpBillreordAddRequest extends BaseTaobaoRequest<FuwuSpBillreordAddResponse> {
	
	

	/** 
	* 确认单的账单明细
	 */
	private String paramBillRecordDTO;

	public void setParamBillRecordDTO(String paramBillRecordDTO) {
		this.paramBillRecordDTO = paramBillRecordDTO;
	}

	public void setParamBillRecordDTO(BillRecordDto paramBillRecordDTO) {
		this.paramBillRecordDTO = new JSONWriter(false,true).write(paramBillRecordDTO);
	}

	public String getParamBillRecordDTO() {
		return this.paramBillRecordDTO;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.sp.billreord.add";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_bill_record_d_t_o", this.paramBillRecordDTO);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuSpBillreordAddResponse> getResponseClass() {
		return FuwuSpBillreordAddResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}