package com.taobao.api.request;

import com.taobao.api.domain.IncomeConfirmDto;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.FuwuSpConfirmApplyResponse;

/**
 * TOP API: taobao.fuwu.sp.confirm.apply request
 * 
 * @author top auto create
 * @since 1.0, 2015.09.10
 */
public class FuwuSpConfirmApplyRequest extends BaseTaobaoRequest<FuwuSpConfirmApplyResponse> {
	
	

	/** 
	* 确认单申请
	 */
	private String paramIncomeConfirmDTO;

	public void setParamIncomeConfirmDTO(String paramIncomeConfirmDTO) {
		this.paramIncomeConfirmDTO = paramIncomeConfirmDTO;
	}

	public void setParamIncomeConfirmDTO(IncomeConfirmDto paramIncomeConfirmDTO) {
		this.paramIncomeConfirmDTO = new JSONWriter(false,true).write(paramIncomeConfirmDTO);
	}

	public String getParamIncomeConfirmDTO() {
		return this.paramIncomeConfirmDTO;
	}

	public String getApiMethodName() {
		return "taobao.fuwu.sp.confirm.apply";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("param_income_confirm_d_t_o", this.paramIncomeConfirmDTO);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FuwuSpConfirmApplyResponse> getResponseClass() {
		return FuwuSpConfirmApplyResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}